<?
/**
 * Generator_Generator_Project
 * 
 * Project用Generator。
 * 
 * @package    Samurai
 * @subpackage Generator
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Generator_Generator_Project extends Generator
{
    public
        /** @var        string  .samurai */
        $SKELETON_DOT_SAMURAI = 'dot.samurai.skeleton.php',
        /** @var        string  www/index.php */
        $SKELETON_WWW_INDEX = 'www/index.skeleton.php',
        /** @var        string  www/info.php */
        $SKELETON_WWW_INFO = 'www/info.skeleton.php',
        /** @var        string  www/.htaccess */
        $SKELETON_WWW_HTACCESS = 'www/htaccess.skeleton.php',
        /** @var        string  www/samurai/samurai.css */
        $SKELETON_WWW_SAMURAI_CSS = 'www/css.skeleton.php',
        /** @var        string  close icon image */
        $SKELETON_WWW_SAMURAI_IMAGE_CLOSE = 'close.gif',
        /** @var        string  error icon image */
        $SKELETON_WWW_SAMURAI_IMAGE_ERROR = 'error.gif',
        /** @var        string  info icon image */
        $SKELETON_WWW_SAMURAI_IMAGE_INFO = 'info.gif',
        /** @var        string  reload icon image */
        $SKELETON_WWW_SAMURAI_IMAGE_RELOAD = 'reload.gif',
        /** @var        string  toggle icon image */
        $SKELETON_WWW_SAMURAI_IMAGE_TOGGLE = 'toggle.gif',
        /** @var        string  warning icon image */
        $SKELETON_WWW_SAMURAI_IMAGE_WARNING = 'warning.gif',
        /** @var        string  config/samurai/config.yml */
        $SKELETON_CONFIG_SAMURAI_YAML = 'config/samurai.yaml.skeleton.php',
        /** @var        string  config/samurai/samurai.dicon */
        $SKELETON_CONFIG_SAMURAI_DICON = 'config/samurai.dicon.skeleton.php',
        /** @var        string  config/samurai/frontfilter.yml */
        $SKELETON_CONFIG_SAMURAI_FRONTFILTER = 'config/samurai.frontfilter.skeleton.php',
        /** @var        string  config/renderer/smarty.php */
        $SKELETON_CONFIG_RENDERER_SMARTY = 'config/renderer.smarty.skeleton.php',
        /** @var        string  config/renderer/simple.php */
        $SKELETON_CONFIG_RENDERER_PHPTAL = 'config/renderer.phptal.skeleton.php',
        /** @var        string  config/renderer/phptal.php */
        $SKELETON_CONFIG_RENDERER_SIMPLE = 'config/renderer.simple.skeleton.php',
        /** @var        string  config/activegateway/activegateway.yml */
        $SKELETON_CONFIG_AG = 'config/ag.skeleton.php',
        /** @var        string  config/routing/routing.yml */
        $SKELETON_CONFIG_ROUTING = 'config/routing.skeleton.php';
    public
        /** @var        int     .samurai識別値 */
        $DOT_SAMURAI = 11,
        /** @var        int     www/index.php識別値 */
        $WWW_INDEX = 21,
        /** @var        int     www/info.php識別値 */
        $WWW_INFO = 22,
        /** @var        int     www/.htaccess識別値 */
        $WWW_HTACCESS = 23,
        /** @var        int     www/samurai/samurai.css識別値 */
        $WWW_SAMURAI_CSS = 241,
        /** @var        int     close icon image識別値 */
        $WWW_SAMURAI_IMAGE_CLOSE = 251,
        /** @var        int     error icon image識別値 */
        $WWW_SAMURAI_IMAGE_ERROR = 252,
        /** @var        int     info icon image識別値 */
        $WWW_SAMURAI_IMAGE_INFO = 253,
        /** @var        int     reload icon image識別値 */
        $WWW_SAMURAI_IMAGE_RELOAD = 254,
        /** @var        int     toggle icon image識別値 */
        $WWW_SAMURAI_IMAGE_TOGGLE = 255,
        /** @var        int     warning icon image識別値 */
        $WWW_SAMURAI_IMAGE_WARNING = 256,
        /** @var        int     config/samurai/config.yml識別値 */
        $CONFIG_SAMURAI_YAML = 311,
        /** @var        int     config/samurai/samurai.dicon識別値 */
        $CONFIG_SAMURAI_DICON = 312,
        /** @var        int     config/samurai/frontfilter.yml識別値 */
        $CONFIG_SAMURAI_FRONTFILTER = 313,
        /** @var        int     config/renderer/smarty.php識別値 */
        $CONFIG_RENDERER_SMARTY = 321,
        /** @var        int     config/renderer/phptal.yml識別値 */
        $CONFIG_RENDERER_PHPTAL = 322,
        /** @var        int     config/renderer/simple.yml識別値 */
        $CONFIG_RENDERER_SIMPLE = 323,
        /** @var        int     config/activegateway/activegateway.yml識別値 */
        $CONFIG_AG = 33,
        /** @var        int     config/routing/routing.yml識別値 */
        $CONFIG_ROUTING = 34;
    
    
    /**
     * Generateトリガーメソッド。
     * @access     public
     */
    public function generate($project_name, $skeleton, $params=array())
    {
        //何もしない
    }
    
    
    /**
     * Dotファイル系のgenerateメソッド。
     * @access     public
     * @param      string  $project_name   プロジェクト名
     * @param      string  $skeleton       スケルトン名
     * @param      array   $params         Rendererに渡される値
     * @param      int     $scope          空間識別値
     * @return     array   結果
     */
    public function generate4Dot($project_name, $skeleton, $params=array(), $scope=NULL){
        if(!$scope) $scope = $this->DOT_SAMURAI;
        $params['project_name'] = $project_name;
        //ドットファイルの決定
        switch($scope){
            case $this->DOT_SAMURAI:
                $dot_file = Samurai_Config::get('generator.directory.samurai') . DS . '.samurai';
                break;
        }
        //generate
        $result = $this->_generate($dot_file, $skeleton, $params);
        return array($result, $dot_file);
    }
    
    
    /**
     * Configファイル系のgenerateメソッド。
     * @access     public
     * @param      string  $project_name   プロジェクト名
     * @param      string  $skeleton       スケルトン名
     * @param      array   $params         Rendererに渡される値
     * @param      int     $scope          空間識別値
     * @return     array   結果
     */
    public function generate4Config($project_name, $skeleton, $params=array(), $scope=NULL){
        if(!$scope) $scope = $this->CONFIG_SAMURAI_YAML;
        $params['project_name'] = $project_name;
        //コンフィグファイルの決定
        $config_dir = Samurai_Config::get('generator.directory.samurai') . DS . Samurai_Config::get('directory.config');
        switch($scope){
            case $this->CONFIG_SAMURAI_YAML:
                $config_file = "{$config_dir}/samurai/config.{$project_name}.yml";
                break;
            case $this->CONFIG_SAMURAI_DICON:
                $config_file = "{$config_dir}/samurai/samurai.{$project_name}.dicon";
                break;
            case $this->CONFIG_SAMURAI_FRONTFILTER:
                $config_file = "{$config_dir}/samurai/frontfilter.{$project_name}.yml";
                break;
            case $this->CONFIG_RENDERER_SMARTY:
                $config_file = "{$config_dir}/renderer/smarty.{$project_name}.php";
                break;
            case $this->CONFIG_RENDERER_PHPTAL:
                $config_file = "{$config_dir}/renderer/phptal.{$project_name}.php";
                break;
            case $this->CONFIG_RENDERER_SIMPLE:
                $config_file = "{$config_dir}/renderer/simple.{$project_name}.php";
                break;
            case $this->CONFIG_AG:
                $config_file = "{$config_dir}/activegateway/activegateway.{$project_name}.yml";
                break;
            case $this->CONFIG_ROUTING:
                $config_file = "{$config_dir}/routing/routing.{$project_name}.yml";
                break;
        }
        //generate
        $result = $this->_generate($config_file, $skeleton, $params);
        return array($result, $config_file);
    }
    
    
    /**
     * Wwwファイル系のgenerateメソッド。
     * @access     public
     * @param      string  $project_name   プロジェクト名
     * @param      string  $skeleton       スケルトン名
     * @param      array   $params         Rendererに渡される値
     * @param      int     $scope          空間識別値
     * @return     array   結果
     */
    public function generate4Www($project_name, $skeleton, $params=array(), $scope=NULL){
        if(!$scope) $scope = $this->WWW_INDEX;
        $params['project_name'] = $project_name;
        $params['samurai_dir'] = Samurai_Config::get('generator.directory.samurai');
        //ファイルの決定
        $www_dir = Samurai_Config::get('generator.directory.samurai') . DS . 'www';
        $is_resource = false;
        switch($scope){
            case $this->WWW_INDEX:
                $www_file = "{$www_dir}/index.php";
                $params['samurai_file'] = SAMURAI_DIR.DS.'Samurai.class.php';
                break;
            case $this->WWW_INFO:
                $www_file = "{$www_dir}/info.php";
                break;
            case $this->WWW_HTACCESS:
                $www_file = "{$www_dir}/.htaccess";
                break;
            case $this->WWW_SAMURAI_CSS:
                $www_file = "{$www_dir}/samurai/samurai.css";
                break;
            case $this->WWW_SAMURAI_IMAGE_CLOSE:
                $www_file = "{$www_dir}/samurai/close.gif";
                $is_resource = true;
                break;
            case $this->WWW_SAMURAI_IMAGE_ERROR:
                $www_file = "{$www_dir}/samurai/error.gif";
                $is_resource = true;
                break;
            case $this->WWW_SAMURAI_IMAGE_INFO:
                $www_file = "{$www_dir}/samurai/info.gif";
                $is_resource = true;
                break;
            case $this->WWW_SAMURAI_IMAGE_RELOAD:
                $www_file = "{$www_dir}/samurai/reload.gif";
                $is_resource = true;
                break;
            case $this->WWW_SAMURAI_IMAGE_TOGGLE:
                $www_file = "{$www_dir}/samurai/toggle.gif";
                $is_resource = true;
                break;
            case $this->WWW_SAMURAI_IMAGE_WARNING:
                $www_file = "{$www_dir}/samurai/warning.gif";
                $is_resource = true;
                break;
        }
        //generate
        $result = $this->_generate($www_file, $skeleton, $params, $is_resource);
        return array($result, $www_file);
    }
    
    
    
    
    
    /**
     * スケルトンの取得。
     * @access     public
     */
    public function getSkeleton($filename){
        $resources = array(
            $this->SKELETON_WWW_SAMURAI_IMAGE_CLOSE,
            $this->SKELETON_WWW_SAMURAI_IMAGE_ERROR,
            $this->SKELETON_WWW_SAMURAI_IMAGE_INFO,
            $this->SKELETON_WWW_SAMURAI_IMAGE_RELOAD,
            $this->SKELETON_WWW_SAMURAI_IMAGE_TOGGLE,
            $this->SKELETON_WWW_SAMURAI_IMAGE_WARNING,
        );
        if(in_array($filename, $resources)){
            return Samurai_Loader::getPath(sprintf('%s/samurai/%s', Samurai_Config::get('directory.resource'), $filename));
        } else {
            return parent::getSkeleton($filename);
        }
    }
}
