<?
/**
 * Generator_Action
 * 
 * SamuraiGenateアクションの抽象クラス。
 * 
 * @package    Samurai
 * @subpackage Generator
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
abstract class Generator_Action extends Samurai_Action
{
    public
        /** @var        array   引数 */
        $args = array(),
        /** @var        array   オプション */
        $options = array(),
        /** @var        string  コマンド */
        $command = '',
        /** @var        string  HOMEディレクトリ */
        $dir_home = '',
        /** @var        string  Samuraiディレクトリ */
        $dir_samurai = '';
    public
        /** @var        object  Generatorコンポーネント */
        $Generator;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        parent::__construct();
        $this->_init();
    }
    
    
    /**
     * 初期化。
     * @access     protected
     */
    protected function _init()
    {
        $now_dir = getcwd();
        $samurai_dir = $this->_searchSamuraiDir($now_dir);
        if($samurai_dir && is_dir($samurai_dir)){
            $this->dir_samurai = $samurai_dir;
            $this->dir_home = dirname($samurai_dir);
        } else {
            $this->dir_samurai = $now_dir.DS.'Samurai';
            $this->dir_home = $now_dir;
        }
    }
    
    
    /**
     * samurai_dirの検索。
     * 現在のディレクトリから遡って、.samuraiファイルのあるディレクトリをsamurai_dirとする。
     * @access     protected
     * @param      string  $dir_now   現在のディレクトリ
     * @return     string  samurai_dir
     */
    protected function _searchSamuraiDir($dir_now)
    {
        $dirs = explode(DS, $dir_now);
        $samurai_dir = array_shift($dirs);
        foreach($dirs as $dir){
            $samurai_dir .= DS.$dir;
            $dot_samurai = $samurai_dir.DS.'.samurai';
            if(file_exists($dot_samurai)){
                return $samurai_dir;
            }
        }
        return false;
    }
    
    
    
    
    
    /**
     * メッセージを投射する。
     * クライアントにダイレクトに出力する。
     * @access     protected
     * @param      string  $message   メッセージ
     * @param      string  $crlf      CRLF
     */
    protected function _sendMessage($message, $crlf="\n")
    {
        echo "{$message}{$crlf}";
        flush();
    }
    
    
    /**
     * Yes/Noの簡単な確認を行う。
     * 正確には、選択肢に対応した値が返却される。
     * @access     protected
     * @param      string  $message   メッセージ
     * @param      array   $choices   選択肢
     * @param      array   $values    選択肢の値
     * @param      string  $default   デフォルトの解答
     */
    protected function _confirm($message, $choices=array('y','n'), $values=array(true,false), $default='n')
    {
        $message = sprintf('%s [%s]: ', $message, join('/', $choices));
        $this->_sendMessage($message, "");
        //ユーザー入力待ち
        $answer = trim(fgets(STDIN));
        //回答の値を取得
        if(!in_array($answer, $choices)) $answer = $default;
        $choices = array_combine($choices, $values);
        return $choices[$answer];
    }
    
    
    
    
    
    /**
     * Usageオプションがついているかどうかの判断。
     * @access     protected
     */
    protected function _isUsage()
    {
        //--help or -[hH] or --usage or -[uU]
        foreach($this->Request->getParameters() as $option_key => $option_value){
            if($option_key == 'help' || $option_key == 'usage'){
                return true;
            } elseif($option_key=='options'){
                foreach($option_value as $option => $_temp){
                    if(in_array($option, array('h','H','u','U'))){
                        return true;
                    }
                }
            }
        }
        return false;
    }
    
    
    /**
     * Versionオプションがついているかどうかの判断。
     * @access     protected
     */
    protected function _isVersion()
    {
        //--version or -[vV]
        foreach($this->Request->getParameters() as $option_key => $option_value){
            if($option_key == 'version'){
                return true;
            } elseif($option_key == 'options'){
                foreach($option_value as $option => $_temp){
                    if(in_array($option, array('v','V'))){
                        return true;
                    }
                }
            }
        }
        return false;
    }
}
