<?
/**
 * Action_Utility_Locate
 * 
 * Commandから指定アクションへのロケートをおこなうためのAction。
 * このアクションが実際の処理を行うことはない。
 * 
 * @package    Samurai
 * @subpackage Generator.Action.Utility
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <samurai@don-quijote.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Action_Utility_Locate extends Generator_Action
{
    /**
     * Actionのロケート。
     * @access     public
     */
    public function execute()
    {
        parent::execute();
        //設定の取得
        $this->_loadSetting();
        //Action
        if($action = $this->_getLocateAction()) return array('success', 'locate_action'=>$action);
        //Usage
        if($this->_isUsage()) return 'usage';
        //Version
        if($this->_isVersion()) return 'version';
        //Info
        if($this->Request->get('info')) return 'info';
        return 'usage';
    }
    
    
    /**
     * ロケート先のアクションを返却。
     * @access     public
     */
    private function _getLocateAction(){
        $action = array_shift($this->args);
        $this->Request->set('args', $this->args);
        if($action){
            $action = str_replace('-', '_', $action);
            if($action == 'spec') $action = 'samurai_spec';
            Samurai_Config::set('action.default', 'error_command');
        }
        return $action;
    }
    
    
    /**
     * 設定をロードする。
     * @access     protected
     */
    protected function _loadSetting()
    {
        //Homeディレクトリの設定
        Samurai_Config::set('directory.home', $this->dir_home);
        //SamuraiDirの設定
        if(!Samurai_Config::get('generator.directory.samurai')){
            Samurai_Config::set('generator.directory.samurai', $this->dir_samurai);
        }
        if($this->Request->get('samurai_dir')){
            $this->dir_samurai = $this->Request->get('samurai_dir');
            Samurai_Config::set('generator.directory.samurai', $this->dir_samurai);
        }
        //設定の読み込み
        $conf_file = $this->dir_samurai.DS.'.samurai';
        if(Samurai_Loader::isReadable($conf_file)){
            Samurai_Config::import($conf_file);
        }
    }
}
