<?
/**
 * Action_Migrate_Db
 * 
 * DBのマイグレーションを実現するコマンド
 * 
 * @package    Samurai
 * @subpackage Generator.Action.Migrate
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Action_Migrate_Db extends Generator_Action
{
    public
        $to,
        $from;
    public
        /** @var        object  FileScannerコンポーネント */
        $FileScanner;
    private
        $_mode = 'up';
    
    
    /**
     * 実行トリガー。
     * @access     public
     */
    public function execute()
    {
        parent::execute();
        //Usage
        if($this->_isUsage()) return 'usage';
        
        //up or down
        $this->_setFrom();
        if($this->to !== NULL && $this->to < $this->from){
            $this->_mode = 'down';
        }
        
        //ActiveGatewayのロード
        $this->_loadActiveGateway();
        
        //マイグレートファイルを収集する
        $migrates = $this->_collectMigrates();
        try {
            foreach($migrates as $migrate){
                $temp = $migrate->matches[2];
                $temp = join('', array_map('ucfirst', explode('_', $temp)));
                $class = 'Migrate_' . $temp;
                Samurai_Loader::load($migrate->path);
                $migrator = new $class();
                if(! $migrator instanceof Samurai_Migration){
                    throw new Samurai_Exception('Not Migrator');
                } else {
                    $this->_sendMessage('== ' . $temp . ': migrating ====================');
                    $migrator->dsn = $this->Request->get('dsn', 'base');
                    $migrator->start();
                    $migrator->setup();
                    $migrator->{$this->_mode}();
                    if($migrator->message){
                        $this->_sendMessage('-- ' . $migrator->message);
                        $this->_sendMessage('     -> ' . $migrator->getTime() . 's');
                    } else {
                        $this->_sendMessage('     -> ' . $migrator->getTime() . 's');
                    }
                    $this->_sendMessage('== ' . $temp . ': migrated (' . $migrator->getTime() . 's) ===========');
                }
            }
            $this->_sendMessage($migrates->getSize() > 0 ? 'finished all migration.' : 'not found migrations to do.');
        } catch(Exception $E){
            $this->_sendMessage('!!! failed to migrate.');
            $this->_sendMessage($E->getMessage());
        }
        
        //ログを残す
        if($migrates->getSize()){
            $last_file = Samurai_Config::get('generator.directory.samurai') . '/log/migrate.db.last';
            file_put_contents($last_file, $migrate->matches[1]);
        }
    }
    
    
    /**
     * マイグレートファイルを収集する
     * @access     private
     */
    private function _collectMigrates()
    {
        $directory = Samurai_Config::get('generator.directory.samurai') . '/migrate/db';
        $condition = $this->FileScanner->getCondition();
        $condition->setRegexp('/^([0-9]+)_([\w_]+)\.php$/');
        $files = $this->FileScanner->scan($directory, $condition);
        foreach($files as $_key => $file){
            $id = floatval($file->matches[1]);
            if($this->_mode == 'up'){
                if($this->to === NULL){
                    if($id < $this->from){
                        $files->remove($_key);
                    }
                } else {
                    if($id < $this->from || $id > $this->to){
                        $files->remove($_key);
                    }
                }
            } else {
                if($id < $this->to || $id > $this->from){
                    $files->remove($_key);
                }
            }
        }
        if($this->_mode == 'down') $files->reverse();
        return $files;
    }
    
    
    
    
    
    /**
     * fromをセットする
     * @access     private
     */
    public function _setFrom()
    {
        if($this->from === NULL){
            $this->from = 0;
            $last_file = Samurai_Config::get('generator.directory.samurai') . '/log/migrate.db.last';
            if(Samurai_Loader::isReadable($last_file)){
                $this->from = floatval(file_get_contents($last_file)) + 1;
            }
        } else {
            $this->from = floatval($this->from);
        }
    }
    
    
    /**
     * ActiveGatewayをロード
     * @access     private
     */
    private function _loadActiveGateway()
    {
        Samurai_Loader::load('library/ActiveGateway/ActiveGatewayManager.class.php');
        $Manager = ActiveGatewayManager::singleton();
        $appname = $this->Request->get('appname', Samurai_Config::get('generator.samurai.application_name'));
        $environment = $this->Request->get('env', 'production');
        $config_dir = Samurai_Config::get('generator.directory.samurai') . '/'
                        . Samurai_Config::get('generator.directory.config', Samurai_Config::get('directory.config'));
        $Manager->import(sprintf('%s/activegateway/activegateway.yml', $config_dir));
        $Manager->import(sprintf('%s/activegateway/activegateway.%s.yml', $config_dir, $appname));
        $Manager->import(sprintf('%s/activegateway/activegateway.%s.yml', $config_dir, $environment));
    }
}
