<?
/**
 * Action_Add_Action
 * 
 * Actionを生成する。
 * 
 * @package    Samurai
 * @subpackage Generator.Action.Add
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Action_Add_Action extends Generator_Action
{
    public
        /** @var        string  テンプレート指定 */
        $template = '';
    
    
    /**
     * 実行。
     * @access     public
     */
    public function execute()
    {
        parent::execute();
        //Usage
        if($this->_isUsage() || !$this->args) return 'usage';
        //入力チェック
        if(!$this->_checkInput()) return 'usage';
        //テンプレートオプションの調節
        $this->_adjustTemplateOption();
        //ループ(アクションを複数指定する事が可能)
        $templates = explode(',', $this->template);
        while($action_name = array_shift($this->args)){
            //Actionの追加
            $action_name = strtolower($action_name);
            $action_file = $this->_addAction($action_name);
            //yamlの追加
            if($action_file){
                //Template
                $template = array_shift($templates);
                $this->_addYaml($action_name, $action_file, $this->Generator->YAML_GLOBAL);
                $this->_addYaml($action_name, $action_file, $this->Generator->YAML_ACTION, array('template'=>$template));
                if($this->Request->get('options.d') || $this->Request->get('dicon')){
                    $this->_addDicon($action_name, $action_file, $this->Generator->DICON_GLOBAL);
                    $this->_addDicon($action_name, $action_file, $this->Generator->DICON_ACTION);
                }
            }
        }
        if($this->template){
            $this->Request->set('args', explode(',', $this->template));
            return "template";
        }
    }
    
    
    /**
     * 入力チェック。
     * @access     private
     * @return     boolean エラーがあったかどうか
     */
    private function _checkInput()
    {
        //アクション名のチェック
        foreach($this->args as $action_name){
            if(!preg_match('/^[a-z][a-z0-9_]*?$/', $action_name)){
                $this->ErrorList->add('action_name', "{$action_name} -> Action's name is Invalid. ([a-z0-9_])");
            } elseif(preg_match('/[_]{2,}/', $action_name)){
                $this->ErrorList->add("action_name", "{$action_name} -> Action's name is Invalid. (Don't use \"_(under bar)\" continously)");
            }
        }
        return !$this->ErrorList->isExists();
    }
    
    
    /**
     * テンプレートオプションの調節。
     * -t オプションで自動でテンプレートファイルを命名。
     * @access     private
     */
    private function _adjustTemplateOption()
    {
        if(!$this->Request->get('notemplate')){
            foreach($this->args as $action){
                $template = sprintf('%s.%s', strtolower(join('/', explode('_', $action))),
                                        Samurai_Config::get('generator.renderer.suffix', 'tpl'));
                $this->template .= $this->template ? ",{$template}" : $template ;
            }
        }
    }
    
    
    /**
     * アクションを追加する。
     * @access     private
     * @param      string  $action_name   Action名
     * @param      array   $params        Rendererに渡される値
     */
    private function _addAction($action_name, $params=array())
    {
        //Skeletonの決定
        $skeleton = $this->Generator->getSkeleton();
        //Generate
        list($result, $action_file) = $this->Generator->generate($action_name, $skeleton, $params);
        if($result == $this->Generator->RESULT_SUCCESS){
            $this->_sendMessage("{$action_name} -> Successfully generated. [{$action_file}]");
        } elseif($result == $this->Generator->RESULT_ALREADY){
            $this->_sendMessage("{$action_name} -> Already exists. [{$action_file}] -> skip");
        } else {
            $this->_sendMessage("{$action_name} -> Failed.");
        }
        return $action_file;
    }
    
    
    /**
     * YAMLを追加する。
     * @access     private
     * @param      string  $action_name   Action名
     * @param      string  $action_file   Actionパス
     * @param      int     $scope         YAMLの空間値
     * @param      array   $params        Rendererに渡される値
     */
    private function _addYaml($action_name, $action_file, $scope, $params=array())
    {
        //Skeletonの決定
        $skeleton = $this->Generator->getSkeleton($this->Generator->SKELETON_YAML);
        //Generate
        $params['action_names'] = explode("_", $action_name);
        if($scope == $this->Generator->YAML_GLOBAL){
            $params['action'] = false;
            $params['global'] = true;
            array_pop($params['action_names']);
            array_push($params['action_names'], '*');
        } elseif($scope == $this->Generator->YAML_ACTION){
            $params['action'] = true;
            $params['global'] = false;
        }
        list($result, $yaml_file) = $this->Generator->generate4Yaml($action_file, $skeleton, $params, $scope);
        $yaml_base = basename($yaml_file);
        if($result == $this->Generator->RESULT_SUCCESS){
            $this->_sendMessage("{$yaml_base} -> Successfully generated. [{$yaml_file}]");
        } elseif($result == $this->Generator->RESULT_ALREADY){
            $this->_sendMessage("{$yaml_base} -> Already exists. [{$yaml_file}] -> skip");
        } else {
            $this->_sendMessage("{$yaml_base} -> Failed.");
        }
    }
    
    
    /**
     * diconを追加する。
     * @access     private
     * @param      string  $action_name   Action名
     * @param      string  $action_file   Actionパス
     * @param      int     $scope         DICONの空間値
     * @param      array   $params        Rendererに渡される値
     */
    private function _addDicon($action_name, $action_file, $scope, $params=array())
    {
        //Skeletonの決定
        $skeleton = $this->Generator->getSkeleton($this->Generator->SKELETON_DICON);
        //Generate
        $params['action_names'] = explode("_", $action_name);
        if($scope == $this->Generator->DICON_GLOBAL){
            array_pop($params['action_names']);
            array_push($params['action_names'], '*');
        }
        list($result, $dicon_file) = $this->Generator->generate4Dicon($action_file, $skeleton, $params, $scope);
        $dicon_base = basename($dicon_file);
        if($result == $this->Generator->RESULT_SUCCESS){
            $this->_sendMessage("{$dicon_base} -> Successfully generated. [{$dicon_file}]");
        } elseif($result == $this->Generator->RESULT_ALREADY){
            $this->_sendMessage("{$dicon_base} -> Already exists. [{$dicon_file}] -> skip");
        } else {
            $this->_sendMessage("{$dicon_base} -> Failed.");
        }
    }
}
