<?
/**
 * config/renderer/smarty.php
 * 
 * Smarty用の初期化スクリプト。
 * Samurai_Renderer::initメソッドの中でインクルードされるので、
 * $this->Engine
 * でSmartyを参照できる。
 * 
 * @package    Samurai
 * @subpackage Config.Renderer
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
//ディレクトリ
$this->Engine->template_dir = Samurai_Config::get('directory.template');
$this->Engine->compile_dir = Samurai_Loader::getPath(Samurai_Config::get('directory.temp').'/smarty/compile', true);
$this->Engine->cache_dir = Samurai_Loader::getPath(Samurai_Config::get('directory.temp').'/smarty/cache', true);
$this->Engine->config_dir = Samurai_Loader::getPath(Samurai_Config::get('directory.config').'/renderer/smarty');
$this->Engine->plugins_dir  = array(
    Samurai_Loader::getPath(Samurai_Config::get('directory.library').'/Smarty/plugins'),
    'plugins',
);

//その他のプロパティ
$this->Engine->error_reporting = NULL;
$this->Engine->compile_check = true;
$this->Engine->force_compile = false;
$this->Engine->caching = 0;
$this->Engine->cache_lifetime = 3600;
$this->Engine->cache_modified_check = false;
$this->Engine->left_delimiter = '{';
$this->Engine->right_delimiter = '}';

//Helper
$Helper = $this->addHelper('ErrorList', array('class'=>'Etc_Helper_Smarty_ErrorList'));

//アプリケーションによる上書用ファイルのインクルード
$application_override = sprintf('config/renderer/smarty.%s.php', SAMURAI_APPLICATION_NAME);
$application_override = Samurai_Loader::getPath($application_override);
if(Samurai_Loader::isReadable($application_override)) include($application_override);
//環境による上書用ファイルのインクルード
if(defined('SAMURAI_ENVIRONMENT')){
    $environment_override = sprintf('config/renderer/smarty.%s.php', SAMURAI_ENVIRONMENT);
    $environment_override = Samurai_Loader::getPath($environment_override);
    if(Samurai_Loader::isReadable($environment_override)) include($environment_override);
}
