<?
/**
 * Samurai_Restful_ActionChain
 * 
 * RESTfulなActionChainを統括するクラス。
 * 
 * @package    Samurai
 * @subpackage Samurai
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
Samurai_Loader::loadByClass('Samurai_ActionChain');
Samurai_Loader::loadByClass('Samurai_Restful_Action');
class Samurai_Restful_ActionChain extends Samurai_ActionChain
{
    public
        /** @var        object  Request */
        $Request;
    
    
    /**
     * コンストラクタ。
     * @access    public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * Actionの実行。
     * @access     public
     * @param      object  $Action       Action
     * @param      string  $error_type   既にエラーが発生していた場合の値
     * @return     mixed   Actionの実行結果
     */
    public function executeAction($Action, $error_type)
    {
        $method = strtolower($this->Request->getMethod()) . ucfirst($error_type);
        if(method_exists($Action, $method)){
            $result = $Action->$method();
        } else {
            $result = $error_type;
        }
        return $result;
    }
}
