<?
/**
 * Samurai_Request_Upload
 * 
 * Requestで受け取ったファイル値を格納する。
 * アップロード版Request。
 * 
 * @package    Samurai
 * @subpackage Samurai.Request
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Samurai_Request_Upload
{
    private
        /** @var        array   ファイル格納 */
        $Files;
    
    
    /**
     * コンストラクタ。
     * @access    public
     */
    public function __construct()
    {
        Samurai_Loader::loadByClass('Samurai_Request_Upload_File');
        $this->Files = new Samurai_Request_Upload_File();
        foreach($_FILES as $name => $file){
            $File = new Samurai_Request_Upload_File($file);
            $this->Files->addFile($File, $name);
        }
    }
    
    
    
    
    
    /**
     * 格納されたファイルを取得する。
     * @access     public
     * @param      string  $name   キー(default=NULL)
     * @return     array   ファイル配列
     */
    public function getFiles($name=NULL)
    {
        return $this->Files->getFiles($name);
    }
    
    
    /**
     * ファイルを取得する。
     * @access     public
     * @param      string  $name   キー
     * @return     object  Samurai_Request_Upload_File
     */
    public function getFile($name)
    {
        return $this->Files->getFile($name);
    }
    
    
    
    
    
    /**
     * ファイル名(主に拡張子)の調節を行う。
     * jpeg=jpg、html=htmなど、同じ意味でも表記にずれがあるものを調節。
     */
    private function _regulateFileName($file_name){
        $pathinfo = pathinfo($file_name);
        if(isset($pathinfo['extension'])){
            switch($pathinfo['extension']){
                case 'jpeg':
                    $pathinfo['extension'] = "jpg"; break;
                case 'htm':
                    $pathinfo['extension'] = "html"; break;
            }
        } else {
            $pathinfo['extension'] = "";
        }
        $pathinfo['extension'] = strtolower($pathinfo['extension']);
        return preg_replace("/\..*$/", ".".$pathinfo['extension'], $file_name);
    }
}
