<?
/**
 * Samurai_Logger_Client_SimpleFile
 * 
 * ロガークライアントの一つ。
 * ファイルへ単純に書き出します。
 * ローテーションは単純にサイズで行います。
 * 
 * @package    Samurai
 * @subpackage Samurai.Logger.Client
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Samurai_Logger_Client_SimpleFile extends Samurai_Logger_Client
{
    public
        /** @var        string  ログファイル */
        $logfile = 'log/logger_simple_file.log',
        /** @var        int     ログファイルの最大サイズ */
        $maxsize = 512000000;
    
    
    /**
     * 設定内容をセット。
     * @access     public
     * @see        Samurai_Logger_Client::define
     */
    public function define(array $define)
    {
        parent::define($define);
        foreach($define as $_key => $_val){
            switch($_key){
                case 'maxsize':
                    $this->$_key = (int)$_val;
                    break;
                case 'logfile':
                    $this->$_key = (string)$_val;
                    break;
            }
        }
    }
    
    
    
    /**
     * トリガーコマンド。
     * @access     public
     * @see        Samurai_Logger_Client::trigger
     */
    public function trigger($level, $message, $file, $line)
    {
        $_logfile = $this->_setLogfile();
        $this->_output($this->logfile, array("[$level]", $message, "{$file}(line{$line})"));
        if($this->_isSizeover($this->logfile, $this->maxsize)){
            $this->_backup($this->logfile);
        }
        $this->_setLogfile($_logfile);
    }
    
    
    /**
     * ファイルに出力する。
     * @access     private
     * @param      string  $logfile    ログファイル
     * @param      array   $messages   メッセージ配列
     */
    private function _output($logfile, array $messages=array())
    {
        //メッセージの補完
        array_unshift($messages, date('Y/m/d H:i:s'));
        array_push($messages, isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : '');
        array_push($messages, isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '');
        array_push($messages, isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : '');
        foreach($messages as &$message) $message = preg_replace("/[\r\n\t]+/", ' ', $message);
        //出力
        $handle = fopen($logfile, 'a+');
        fwrite($handle, join("\t", $messages)."\r\n");
        fclose($handle);
        @chmod($logfile, 0777);
    }
    
    
    /**
     * ログファイルがサイズオーバーしていないかチェック。
     * @access     private
     * @param      string  $logfile   ログファイル
     * @param      int     $maxsize   最大サイズ
     */
    private function _isSizeover($logfile, $maxsize)
    {
        return filesize($logfile) >= $maxsize;
    }
    
    
    /**
     * ログファイルをバックアップします。
     * @access     private
     * @param      string  $logfile   バックアップ対象ファイル
     */
    private function _backup($logfile)
    {
        $backup = $logfile.'.'.date('YmdHis');
        copy($logfile, $backup);
        @chmod($backup, 0777);
        file_put_contents($logfile, '');
    }
    
    
    
    
    
    /**
     * Samurai_Configでsamrai_dirに追加があった場合に対処できるように。
     * @access     private
     * @param      string  $logfile
     * @return     string  変更される前のlogfile
     */
    private function _setLogfile($logfile=NULL)
    {
        if($logfile){
            $this->logfile = $logfile;
            return $this->logfile;
        } else {
            $_logfile = $this->logfile;
            $log_dir = Samurai_Loader::getPath(dirname($this->logfile));
            $this->logfile = $log_dir.DS.basename($this->logfile);
            return $_logfile;
        }
    }
}
