<?
/**
 * Samurai_Filter.abstract
 * 
 * Filterの抽象クラス。
 * 
 * @package    Samurai
 * @subpackage Samurai
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
abstract class Samurai_Filter
{
    private
        /** @var        array   属性 */
        $_attributes = array();
    
    
    /**
     * コンストラクタ。
     * @access    public
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * フィルター特有の処理を実装する。
     * @access    public
     */
    public function execute()
    {
        $this->_prefilter();
        $this->_chainfilter();
        $this->_postfilter();
    }
    
    
    /**
     * preFilter。
     * execute内で呼ばれるべき関数。
     * @access    protected
     */
    protected function _prefilter()
    {
        Samurai::getContainer()->injectDependency($this);
        Samurai_Logger::debug('Filter::_prefilter executed. -> %s', get_class($this));
    }
    /**
     * postFilter。
     * execute内で呼ばれるべき関数。
     * @access    protected
     */
    protected function _postfilter()
    {
        Samurai::getContainer()->injectDependency($this);
        Samurai_Logger::debug('Filter::_postfilter executed. -> %s', get_class($this));
    }
    /**
     * フィルターをつなげる関数。
     * execute内で呼ばれるべき関数。
     * むしろ、必ず呼び出すこと。この関数を呼び出さないと、Filterがつながらない。
     * @access    protected
     */
    protected function _chainfilter(){
        $FilterChain = Samurai::getContainer()->getComponent('FilterChain');
        $FilterChain->execute();
    }
    
    
    
    
    
    /**
     * 属性の長さを返却する。
     * @access    public
     * @return    int   属性の配列の長さ
     */
    public function getSize()
    {
        return count($this->_attributes);
    }
    
    
    /**
     * 指定された属性を返却する。
     * @access     public
     * @param      string  $key       属性キー
     * @param      mixed   $default   デフォルト値
     * @return     mixed   属性の値
     */
    public function getAttribute($key, $default=NULL)
    {
        $keys = explode('.', $key);
        $attribute = $default;
        foreach($keys as $_key => $_val){
            if(!$_key && isset($this->_attributes[$_val])){
                $attribute = $this->_attributes[$_val];
            } elseif(is_array($attribute) && isset($attribute[$_val])){
                $attribute = $attribute[$_val];
            } else {
                $attribute = $default;
            }
        }
        return $attribute;
    }
    
    
    /**
     * 属性をすべて取得。
     * @access    public
     * @return    array   属性の全て
     */
    public function getAttributes()
    {
        return $this->_attributes;
    }
    
    
    /**
     * 指定された属性に値をセット。
     * @access    public
     * @param     string  $key     属性のキー
     * @param     mixed   $value   属性の値
     */
    public function setAttribute($key, $value)
    {
        $this->_attributes[$key] = $value;
    }
    
    
    /**
     * 指定された属性に値をまとめてセット。
     * @access    public
     * @param     array   $attributes   格納したい属性配列
     */
    public function setAttributes(array $attributes)
    {
        $this->_attributes = array_merge($this->_attributes, $attributes);
    }
}
