<?
/**
 * Samurai_Action.abstract
 * 
 * Actionクラスの抽象クラス。
 * SamuraiFWで実行されるActionクラスは、すべてこの抽象クラスを継承しなければならない。
 * 
 * @package    Samurai
 * @subpackage Samurai
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <samurai@don-quijote.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Samurai_Action
{
    public
        /** @var        object  Deviceコンポーネント */
        $Device,
        /** @var        object  Requestコンポーネント */
        $Request,
        /** @var        object  Cookieコンポーネント */
        $Cookie,
        /** @var        object  Sessionコンポーネント */
        $Session,
        /** @var        object  現在のActionのErrorList */
        $ErrorList,
        /** @var        object  Rendererコンポーネント */
        $Renderer;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * 通常実行されるメソッド。
     * @access     public
     */
    public function execute()
    {
        Samurai_Logger::debug('Executed Action. -> %s', get_class($this));
    }
    
    
    /**
     * レンダラーの前に実行される。
     * @access     public
     */
    public function beforeRenderer()
    {
        
    }
}
