<?
/**
 * Filter_Debug_Debugger_Log
 * 
 * Filter_Debugで使用されるLogデバッガ。
 * Samurai_Loggerの内容をデバッグウインドウに反映する。
 * 
 * @package    Filter
 * @subpackage Debug
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Debug_Debugger_Log extends Filter_Debug_Debugger
{
    public
        $position = 'top',
        $icon = '/samurai/info.gif',
        $heading = 'Samurai_Logger';
    private
        $_logs = array();
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * setup.
     * @implements
     */
    public function setup()
    {
        $logs = Samurai_Logger::getMessages();
        foreach($logs as $_key => $log){
            $time = (!$_key) ? $log['time']-SAMURAI_START : $log['time']-$logs[$_key-1]['time'] ;
            $log['time'] = $time*1000;
            $log['error'] = $log['level'] >= 3;
            $log['image'] = sprintf('<IMG src="/samurai/%s">', $log['error'] ? 'error.gif' : 'info.gif');
            switch($log['level']){
                case 1: $log['level'] = 'debug'; break;
                case 2: $log['level'] = 'info';  break;
                case 3: $log['level'] = 'warn';  break;
                case 4: $log['level'] = 'error'; break;
                case 5: $log['level'] = 'fatal'; break;
            }
            if($log['error']) $this->_has_error = true;
            $this->_logs[] = $log;
        }
    }
    
    
    /**
     * _getContent.
     * @override
     */
    protected function _getContent()
    {
        $content = array();
        $content[] = '<TABLE class="list">';
        $content[] = '<TR><TH style="width:25px;">#</TH><TH style="width:25px;">　</TH><TH style="width:50px;">ms</TH>'
                        .'<TH style="width:60px;">level</TH><TH>message</TH></TR>';
        foreach($this->_logs as $_key => $log){
            $class = $log['error'] ? 'error' : 'item' ;
            $content[] = sprintf('<TR class="%s"><TD>%d</TD><TD style="text-align:center;">%s</TD><TD>+%0.1f</TD>'
                                    .'<TD style="text-align:center;">[%s]</TD><TD>%s</TD></TR>',
                                    $class, $_key, $log['image'], $log['time'], $log['level'], htmlspecialchars($log['message']));
        }
        $content[] = '</TABLE>';
        return join("\r\n", $content);
    }
}
