<?
/**
 * Filter_Debug_Debugger_ActiveGateway
 * 
 * Filter_Debugで使用されるActiveGatewayデバッガ。
 * ActiveGAtewayの内容をデバッグウインドウに反映する。
 * 
 * @package    Filter
 * @subpackage Debug
 * @see        ActiveGateway
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Debug_Debugger_ActiveGateway extends Filter_Debug_Debugger
{
    public
        $position = 'menu',
        $icon = 'ActiveGateway',
        $heading = 'ActiveGateway';
    private
        $_queries = array();
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * setup.
     * @implements
     */
    public function setup()
    {
        if(class_exists('ActiveGatewayManager')){
            $this->_queries = ActiveGatewayManager::getPoolQuery();
        }
        foreach($this->_queries as $_key => $query){
            $query['error'] = $query['time'] > 0.5;
            $query['image'] = sprintf('<IMG src="/samurai/%s">', $query['error'] ? 'error.gif' : 'info.gif');
            $query['time'] = $query['time'] * 1000;
            $this->_queries[$_key] = $query;
            if($query['error']) $this->_has_error = true;
        }
    }
    
    
    /**
     * _getContent.
     * @override
     */
    protected function _getContent()
    {
        $content = array();
        $content[] = '<TABLE class="list">';
        $content[] = '<TR><TH style="width:25px;">#</TH><TH style="width:25px;">　</TH><TH style="width:50px;">ms</TH><TH>query</TH></TR>';
        foreach($this->_queries as $_key => $query){
            $class = $query['error'] ? 'error' : 'item' ;
            $content[] = sprintf('<TR class="%s"><TD>%d</TD><TD style="text-align:center;">%s</TD><TD>+%0.1f</TD><TD>%s</TD></TR>',
                                    $class, $_key, $query['image'], $query['time'], htmlspecialchars($query['query']));
        }
        $content[] = '</TABLE>';
        return join("\r\n", $content);
    }
}
