<?
/**
 * Filter_Debug_Debugger.abstract
 * 
 * Filter_Debugで使用されるデバッガの抽象クラス。
 * すべてのデバッガはこれを継承する。
 * 
 * @package    Filter
 * @subpackage Debug
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
abstract class Filter_Debug_Debugger
{
    public
        /** @var        string  表示場所(menu|top) */
        $position = 'menu',
        /** @var        string  表示文字列 | アイコン画像 */
        $icon = 'Debugger',
        /** @var        string  見出し */
        $heading = 'Debugger';
    protected
        /** @var        int     デバッガーの一意のインデックス */
        $_index = 0,
        /** @var        mixed   表示内容 */
        $_content,
        /** @var        boolean エラーが発生しているかどうか */
        $_has_error = false,
        /** @var        boolean 内容をエスケープするかどうか */
        $_escape = true;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * セットアップ。
     * @access     public
     */
    public abstract function setup();
    
    
    /**
     * 内容の取得。
     * @access     public
     * @return     string  コンテンツ
     */
    public function getContent()
    {
        $contents = array();
        $contents[] = $this->_getHeader();
        $contents[] = $this->_getContent();
        $contents[] = $this->_getFooter();
        return join("\r\n", $contents);
    }
    
    
    /**
     * フッターコンテンツの取得。
     * @access     public
     * @return     string  フッターコンテンツ
     */
    public function getFooterContent()
    {
        return '';
    }
    
    
    /**
     * ヘッダーの取得。
     * @access     protected
     * @return     string  ヘッダー
     */
    protected function _getHeader()
    {
        $header = '<DIV id="samurai_debug_console_window_' . $this->_index . '" class="samurai_debug_console_window">';
        $header .= '<DIV class="header">';
        $header .= '<DIV style="float:left;">' . $this->heading . '</DIV>';
        $header .= '<DIV style="float:right;">'
                    .'<IMG src="/samurai/close.gif" class="icon" style="cursor:pointer;" onClick="' . $this->onClick() . '"></DIV>';
        $header .= '<DIV style="clear:both;"></DIV>';
        $header .= '</DIV>';
        $header .= '<DIV class="content">';
        return $header;
    }
    
    
    /**
     * 内容の取得。
     * @access     private
     * @return     string  内容
     */
    protected function _getContent()
    {
        ob_start();
        dBug::$no_escape = !$this->_escape;
        new dBug($this->_content);
        $content = ob_get_contents();
        ob_end_clean();
        return $content;
    }
    
    
    /**
     * フッターの取得。
     * @access     protected
     * @return     string  フッター
     */
    protected function _getFooter()
    {
        $footer = '</DIV>';
        $footer .= '</DIV>';
        return $footer;
    }
    
    
    
    
    
    /**
     * onClick.
     * @access     public
     * @return     string  onClick時の挙動
     */
    public function onClick()
    {
        return "SamuraiDebug.swapWindow('samurai_debug_console_window_{$this->_index}');";
    }
    
    
    /**
     * indexをセット。
     * @access     public
     * @param      int     $index   index
     */
    public function setIndex($index)
    {
        $this->_index = $index;
    }
    
    
    /**
     * エラーが発生しているかどうか。
     * @access     public
     * @return     boolean エラーが発生しているかどうか
     */
    public function hasError()
    {
        return $this->_has_error;
    }
}
