<?
/**
 * Filter_Convert_Converter_Native
 * 
 * nativeなPHP関数へブリッジする。
 * 
 * @package    Samurai
 * @subpackage Filter.Convert
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Convert_Converter_Native extends Filter_Convert_Converter
{
    private
        $_function = '';
    
    
    /**
     * コンストラクタ。
     * @access     public
     * @param      string  $function   関数名
     */
    public function __construct($function)
    {
        if(function_exists($function)){
            $this->_function = $function;
        } else {
            throw new Samurai_Exception("指定のコンバーターが見つかりません。 -> {$function}");
        }
    }
    
    
    /**
     * nativeなPHP関数にブリッジ。
     * @access     protected
     */
    protected function _convert($value)
    {
        $function = $this->_function;
        return $function($value);
    }
}
