<?
/**
 * Filter_Auth_Manager
 * 
 * Author処理を管理するクラス。
 * 
 * @package    Samurai
 * @subpackage Filter.Auth
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
Samurai_Loader::loadByClass('Filter_Auth_Author');
class Filter_Auth_Manager
{
    private
        /** @var        array   Authorキャッシュ */
        $_authors = array();
    
    
    /**
     * コンストラクター。
     * @access    public
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * Authorを取得する。
     * @access     public
     * @param      string  $name   Author名
     * @return     object  Author
     */
    public function getAuthor($name)
    {
        if(!isset($this->_authors[$name])){
            $class = 'Filter_Auth_Author_'.ucfirst($name);
            Samurai_Loader::loadByClass($class);
            $this->_authors[$name] = new $class();
            Samurai::getContainer()->injectDependency($this->_authors[$name]);
        }
        return $this->_authors[$name];
    }
}
