<?
/**
 * Filter_Https
 * 
 * Https通信を強要するフィルター
 * <code>
 *     Https:
 *         required : true
 *         function : isHttps
 *         execute  : location | seterror
 * </code>
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Https extends Samurai_Filter
{
    public
        $Request,
        $Response;
    
    
    /**
     * prefilter.
     * @override
     */
    protected function _prefilter()
    {
        parent::_prefilter();
        
        if($function = $this->getAttribute('function')){
            $result = $function();
        } else {
            $result = $this->Request->isHttps();
        }
        
        //HTTPS通信ではないと判断された場合
        if(!$result){
            $execute = $this->getAttribute('execute', 'location');
            switch($execute){
                case 'location':
                    $this->Response->setRedirect(sprintf('https://%s%s', $_SERVER['HTTP_HOST'], $_SERVER['REQUEST_URI']));
                    $this->Response->execute();
                    exit;
                    break;
                case 'seterror':
                    $ErrorList = $this->ActionChain->getCurrentErrorList();
                    $ErrorList->setType(Samurai_Config::get('error.https', 'https'));
                    break;
            }
        }
    }
}
