<?
/**
 * Filter_Cookie
 * 
 * クッキー使用準備をおこなうFilter。
 * このフィルターがなくともCookieは使えるが、使うと楽。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Filter_Cookie extends Samurai_Filter
{
    public
        /** @var        object  Cookieコンポーネント */
        $Cookie,
        /** @var        object  Responseコンポーネント */
        $Response;
    
    
    /**
     * prefilter.
     * @override
     */
    protected function _prefilter()
    {
        parent::_prefilter();
        //Cookieインスタンスの取得
        if(!$this->Cookie){
            $Container = Samurai::getContainer();
            $Def = $Container->getContainerDef();
            $Def->class = 'Samurai_Request_Cookie';
            $Container->registerComponent('Cookie', $Def);
            $this->Cookie = $Container->getComponent('Cookie');
        }
        //情報のセット
        foreach($this->getAttributes() as $_key => $_val){
            switch($_key){
                case 'path':
                    $this->Cookie->setPath((string)$_val);
                    break;
                case 'domain':
                    $this->Cookie->setDomain((string)$_val);
                    break;
                case 'sequre':
                    $this->Cookie->setSequre((bool)$_val);
                    break;
            }
        }
        //IE6用のプライバシーポリシー
        $this->Response->setHeader('P3P', 'CP="UNI CUR OUR"');
    }
}
