<?
/**
 * Etc_Mail_Transporter
 * 
 * Etc_Mailの送信担当者。
 * 
 * @package    Samurai
 * @subpackage Etc.Mail
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
abstract class Etc_Mail_Transporter
{
    protected
        /** @var        object  Etc_Mail */
        $Mail,
        /** @var        object  TOPパート */
        $Part;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * 送信トリガー。
     * @access     public
     * @param      object  $Mail   Etc_Mail
     */
    public function send(Etc_Mail $Mail)
    {
        //初期化
        $this->Mail = $Mail;
        if(!$Mail->hasContent()) throw new Samurai_Exception('Unsetted bodies or attaches');
        //TOPパートの構築
        $this->Part = new Etc_Mail_Mime_Part();
        foreach($this->Mail->getBodies() as $Body){
            $this->Part->addPart($Body);
        }
        foreach($this->Mail->getAttaches() as $Attach){
            $this->Part->addPart($Attach);
        }
        //送信
        $this->_prepareHeader();
        $this->_prepareBody();
        $this->_send();
    }
    
    
    /**
     * 抽象送信トリガー。
     * 各Transporterで実装してください。
     * @access     protected
     */
    protected abstract function _send();
    
    
    /**
     * ヘッダーを調節、補完する。
     * @access     private
     */
    private function _prepareHeader()
    {
        //Return-Path
        $this->Part->setHeader('return-path', $this->Mail->getFrom()->mail);
        //To,Cc,Bcc
        foreach(array('to', 'cc', 'bcc') as $type){
            $_recipients = array();
            foreach($this->Mail->getRecipients($type) as $Recipient){
                $_recipients[] = $Recipient->encodeMimeheader($this->Mail->getCharset());
            }
            if($_recipients) $this->Part->setHeader($type, join(','.$this->Mail->lineend.' ', $_recipients));
        }
        //From
        $this->Part->setHeader('from', $this->Mail->getFrom()->encodeMimeheader($this->Mail->getCharset()));
        //Subject
        $this->Part->setHeader('subject', mb_encode_mimeheader($this->Mail->getSubject(), $this->Mail->getCharset()));
        //Date
        $this->Part->setHeader('date', date('r'));
        //その他
        foreach($this->Mail->getHeaders() as $key => $value){
            $this->Part->setHeader($key, $value);
        }
    }
    
    
    /**
     * メッセージボディを調節、補完する。
     * @access     private
     */
    private function _prepareBody()
    {
        
    }
}
