<?
/**
 * Action_Samurai_Spec
 * 
 * BDD(Behavior Driven Development)開発のためのツール
 * generatorアプリの下に置きたいが、WEB上からのテスト実行もあり得るのでこちらに配置。
 * 
 * @package    Samurai
 * @subpackage Action.Samurai
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Action_Samurai_Spec extends Samurai_Action
{
    private
        $_options = NULL;
    
    
    /**
     * 実行トリガー。
     * @access     public
     */
    public function execute()
    {
        parent::execute();
        //初期化
        $this->_init();
        //SPECのための初期化スクリプトを実行する
        $this->_doInitialization();
        //実行
        PHPSpec_Runner::run($this->_options);
        if($this->Device->isCli()) echo "\n";
    }
    
    
    /**
     * 初期化。
     * @access     private
     */
    private function _init()
    {
        include_once('PHPSpec.php');
        $this->_options = new stdClass();
        $this->_options->recursive = true;
        $this->_options->specdoc = true;
        $this->_options->reporter = $this->Device->isCli() ? 'console' : 'html' ;
        if(Samurai_Config::get('generator.directory.samurai')){
            Samurai::unshiftSamuraiDir(Samurai_Config::get('generator.directory.samurai'));
            if($this->Request->get('directory')){
                chdir(Samurai_Config::get('generator.directory.samurai') . DS . $this->Request->get('directory'));
            } else {
                chdir(Samurai_Config::get('generator.directory.samurai') . DS . Samurai_Config::get('directory.spec'));
            }
        } else {
            chdir(Samurai_Loader::getPath(Samurai_Config::get('directory.spec')));
        }
        //もしファイルの指定があれば
        if($args = $this->Request->get('args')){
            $this->_options->specFile = array_shift($args);
        }
    }
    
    
    /**
     * SPECがSPECのために初期化が必要な場合、
     * Initialization.phpをSPEC直下に配置することで初期化を行うことが出来る
     * @access     private
     */
    private function _doInitialization()
    {
        if($init_file = $this->Request->get('initfile')){
            $init_file = Samurai_Config::get('generator.directory.samurai') . DS . $init_file;
        } else {
            $init_file = getcwd() . '/Initialization.php';
        }
        if(file_exists($init_file)){
            include_once($init_file);
        }
    }
}
