<?
/**
 * Samurai
 * 
 * SamuraiFWのメインクラス。
 * 
 * @package    Samurai
 * @subpackage Component.Samurai
 * @copyright  Befool,Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
defined('PS') ? NULL : define('PS', PATH_SEPARATOR) ;
defined('DS') ? NULL : define('DS', DIRECTORY_SEPARATOR) ;
if(!defined('SAMURAI_DIR')) define('SAMURAI_DIR', dirname(__FILE__));
class Samurai
{
    const
        /** @var        string  バージョン */
        VERSION = '2.0.0';
    private static
        /** @var        array   SAMURAI_DIR候補 */
        $_samurai_dirs = array(SAMURAI_DIR);
    
    
    /**
     * コンストラクタ。
     * @access     private
     */
    private function __construct()
    {
        
    }
    
    
    /**
     * SamuraiFWの初期化を行う。
     * 一度だけ呼び出せばよい。
     * @access     public
     */
    public static function init()
    {
        //スタート
        define('SAMURAI_START', microtime(true));
        if(defined('SAMURAI_MODE') && !defined('SAMURAI_ENVIRONMENT')) define('SAMURAI_ENVIRONMENT', SAMURAI_MODE);
        if(!defined('SAMURAI_ENVIRONMENT')) define('SAMURAI_ENVIRONMENT', 'production');
        //主要クラスのロード
        self::_load();
        //設定情報の取得
        Samurai_Config::import('config/samurai/config.yml');
        //DIContainerの初期化
        $Container = self::getContainer();
        $Container->import(Samurai_Config::get('container.dicon'));
        //Loggerの初期化
        $loggers = Samurai_Config::get('loggers');
        foreach((array)$loggers as $alias => $define){
            Samurai_Logger::addClient($alias, $define);
        }
        //環境用設定ファイルの読込
        Samurai_Loader::includes('config/environment/production.php');
        if(SAMURAI_ENVIRONMENT != 'production') Samurai_Loader::includes('config/environment/' . SAMURAI_ENVIRONMENT . '.php');
    }
    
    
    /**
     * 主要クラスをロードする。
     * @access     private
     */
    private static function _load()
    {
        include_once(SAMURAI_DIR . '/component/samurai/Loader.class.php');
        Samurai_Loader::load('component/samurai/Config.class.php');
        Samurai_Loader::load('component/samurai/Exception.class.php');
        Samurai_Loader::load('component/samurai/Yaml.class.php');
        Samurai_Loader::load('component/samurai/container/Factory.class.php');
        Samurai_Loader::load('component/samurai/Logger.class.php');
        spl_autoload_register(array('Samurai_Loader', 'autoload'));
    }
    
    
    /**
     * DIContainerの取得。
     * @access     public
     * @return     object  Samurai_Container
     */
    public static function getContainer($namespace=NULL)
    {
        if($namespace === NULL) $namespace = Samurai_Config::get('container.name');
        return Samurai_Container_Factory::create($namespace);
    }
    
    
    
    /**
     * samurai_dirを追加する。
     * @access     public
     * @return     array   samurai_dir
     */
    public static function getSamuraiDirs()
    {
        return self::$_samurai_dirs;
    }
    
    
    /**
     * samurai_dirを追加する。
     * @param      string  $dir   ディレクトリ
     */
    public static function unshiftSamuraiDir($dir)
    {
        array_unshift(self::$_samurai_dirs, $dir);
    }
}
