<?
/**
 * ActiveGateway_Driver_Mysql
 * 
 * ActiveGatewayのMysql用ドライバー。
 * 
 * @package    ActiveGateway
 * @subpackage Driver
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class ActiveGateway_Driver_Mysql extends ActiveGateway_Driver
{
    /**
     * 接続。
     * @override
     */
    protected function _connect(array $dsn_info)
    {
        $scheme  = $dsn_info['scheme'];
        $user    = $dsn_info['user'];
        $pass    = $dsn_info['pass'];
        $host    = $dsn_info['host'];
        $db_name = substr($dsn_info['path'],1);
        try {
            $connection = new PDO("mysql:dbname={$db_name};host={$host}", $user, $pass);
        } catch(PDOException $Exception){
            trigger_error(sprintf("[ActiveGateway_Driver_Mysql]:Connection failed... -> [%s]", $Exception->getMessage()), E_USER_ERROR);
        }
        return $connection;
    }
    
    
    
    
    
    /**
     * @override
     */
    public function modifyLimitQuery($sql, $offset=NULL, $limit=NULL)
    {
        if($offset!==NULL && $limit!==NULL){
            $sql = sprintf("%s LIMIT %d, %d", $sql, $offset, $limit);
        } elseif($limit!==NULL){
            $sql = sprintf("%s LIMIT %d", $sql, $limit);
        }
        return $sql;
    }
    /**
     * @override
     */
    public function modifyInsertQuery($table_name, $attributes, &$params=array())
    {
        $i = 1;
        $field_list = array();
        $value_list = array();
        
        foreach($attributes as $_key => $_val){
            $field_list[] = "`{$_key}`";
            $value_list[] = "?";
            $params[$i] = $_val;
            $i++;
        }
        
        return sprintf("INSERT INTO `%s` ( %s ) VALUES ( %s )", $table_name, join(", ", $field_list), join(", ", $value_list));
    }
    /**
     * @override
     */
    public function modifyUpdateQuery($table_name, $sets, $wheres=array(), $orders=array())
    {
        $sql  = sprintf("UPDATE `%s` SET %s", $table_name, join(", ", $sets));
        $sql .= ($wheres) ? sprintf(" WHERE %s", join(" AND ", $wheres)) : "" ;
        return $sql;
    }
    /**
     * @override
     */
    public function modifyDeleteQuery($table_name, $wheres=array(), $orders=array())
    {
        $sql  = sprintf("DELETE FROM `%s`", $table_name);
        $sql .= ($wheres) ? sprintf(" WHERE %s", join(" AND ", $wheres)) : "" ;
        return $sql;
    }
    /**
     * @override
     */
    public function modifyUpdateLimitQuery($sql, $limit=NULL)
    {
        if(is_numeric($limit)){
            $sql = sprintf("%s LIMIT %d", $sql, $limit);
        }
        return $sql;
    }
    /**
     * @override
     */
    public function modifyFoundRowsQuery($sql)
    {
        if(!preg_match("/^SELECT\s*SQL_CALC_FOUND_ROWS/i", $sql)){
            $sql = str_replace("SELECT", "SELECT SQL_CALC_FOUND_ROWS", $sql);
        }
        return $sql;
    }
    
    
    
    
    
    /**
     * @override
     */
    public function getTotalRows($sql, $params=array())
    {
        $stmt = $this->query("SELECT FOUND_ROWS()");
        $row  = $stmt->fetch(PDO::FETCH_NUM);
        return $row[0];
    }
    
    
    
    
    
    /**
     * テーブル情報の取得。
     * @access     public
     * @since      1.0.0
     * @param      string  $table_name   テーブル名
     * @return     array   テーブル情報
     */
    public function getTableInfo($table_name)
    {
        //初期化
        $result = array();
        if($table_name===NULL || $table_name=="" || !is_string($table_name)){
            return $result;
        }
        
        //取得
        $sql = "DESCRIBE `{$table_name}`";
        $stmt = $this->query($sql);
        $table_info = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        //整形
        foreach($table_info as $_key => $info){
            //カラム名の取得
            $name = $info['Field'];
            
            //フィールド型の取得
            if(preg_match("/^(.+)\((.+)\)$/", $info['Type'], $matches)){
                $type   = $matches[1];
                $length = $matches[2];
            } else {
                $type   = $info['Type'];
                $length = NULL;
            }
            
            //NULL値の判断
            $null = ($info['Null']=="YES") ? true : false ;
            
            //キーの取得
            $primary_key = preg_match("/PRI/", $info['Key']) ? true : false ;
            
            //デフォルト値の取得
            $default = $info['Default'];
            
            //その他フラグの取得
            $extras = array();
            if(preg_match("/auto_increment/", $info['Extra'])){
                $extras[] = "auto_increment";
            }
            $extras = join(" ", $extras);
            
            //値の生成
            $result[$name] = array(
                "table"       => $table_name,
                "name"        => $name,
                "type"        => $type,
                "length"      => $length,
                "null"        => $null,
                "primary_key" => $primary_key,
                "default"     => $default,
                "extras"      => $extras,
            );
        }
        
        return $result;
    }
}
