<?
/**
 * Samurai_Request_Http
 * 
 * GET/POSTで受け取った値を格納する。
 * 
 * @package    Samurai
 * @subpackage Request
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <samurai@don-quijote.jp>
 */
Samurai_Loader::loadByClass("Samurai_Request_Parameter");
class Samurai_Request_Http extends Samurai_Request_Parameter
{
    private
        /** @var        array   ヘッダー情報 */
        $_headers = array();
    
    
    /**
     * コンストラクタ。
     * @access    public
     * @since     1.0.0
     */
    public function __construct()
    {
        //COOKIEを取得したくないために、敢えて$_REQUESTで取得しない
        $request = array_merge($_GET, $_POST);
        //自動エスケープ処理を無効化
        if(get_magic_quotes_gpc()){
            array_walk_recursive($request, create_function('&$item', '$item = stripslashes($item);'));
        }
        //文字コードの差異を修正
        if(!ini_get("mbstring.encoding_translation")
            && Samurai_Config::get("encoding.input") != Samurai_Config::get("encoding.internal")){
            mb_convert_variables(Samurai_Config::get("encoding.internal"), Samurai_Config::get("encoding.input"), $request);
        }
        //インポート
        $this->import($request);
    }
    
    
    
    
    
    /**
     * REQUEST_METHODの値を返却。
     * @access    public
     * @return    string   $_SERVER['REQUEST_METHOD']の値(_method値で上書可能)
     */
    public function getMethod()
    {
        return $this->getParameter("_method") ? $this->getParameter("_method") : $_SERVER['REQUEST_METHOD'] ;
    }
    
    
    /**
     * HTTPS通信かどうかを判断する。
     * @access     public
     * @return     boolean HTTPS通信かどうか
     */
    public function isHttps()
    {
        return isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on';
    }
    
    
    /**
     * Actionの強制変化。
     * フォーム内に二つのsubmitボタンがある場合、submitボタンのname属性でActionを切り分ける。
     * <input type="submit" name="dispatch_OK" value="OK">
     *    ⇒ Actionは「OK」になる
     * <input type="submit" name="dispatch_NG" value="NG">
     *    ⇒ Actionは「NG」になる
     * @access    public
     */
    public function dispatchAction(){
        //パラメータの取得
        $parameters = $this->getParameters();
        if(!count($parameters)) return;
        //Actionの割当て
        foreach($parameters as $_key => $_val){
            if(preg_match("/^dispatch_/", $_key)){
                $action = preg_replace("/^dispatch_/", "", $_key);
                $this->setParameter(Samurai_Config::get("action.request_key"), $action);
                Samurai_Logger::info("Dispatched Action -> %s.", array($action));
            }
        }
    }
}
