<?
/**
 * Samurai_Request_Cli
 * 
 * Client用のRequestクラス。
 * 
 * @package    Samurai
 * @subpackage Samurai.Request
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
Samurai_Loader::loadByClass("Samurai_Request_Http");
class Samurai_Request_Cli extends Samurai_Request_Http
{
    /**
     * コンストラクタ。
     * @access    public
     */
    public function __construct()
    {
        $request = array();
        if(isset($_SERVER['argv'])){
            //第一引数は実行ファイルが入ってくる
            $script = array_shift($_SERVER['argv']);
            //その他引数の解釈
            foreach($_SERVER['argv'] as $arg){
                //ロングオプションの場合
                if(preg_match('/^\-\-(..*)/', $arg, $matches)){
                    $option = $matches[1];
                    $option = explode("=", $option);
                    $option_key   = array_shift($option);
                    $option_value = ($option) ? array_shift($option) : true ;
                    $request[$option_key] = $option_value;
                //オプションの場合
                } elseif(preg_match('/^\-(..*)/', $arg, $matches)){
                    $option = $matches[1];
                    for($i=0;isset($option[$i]);$i++){
                        $request['options'][$option[$i]] = true;
                    }
                //それ以外は「args」の中に放り込む
                } else {
                    $request['args'][] = $arg;
                }
            }
        }
        //格納
        $this->import($request);
    }
    
    
    /**
     * @override
     */
    public function getMethod()
    {
        return php_sapi_name();
    }
    
    
    /**
     * CliではActionの上書きはなし。
     * @override
     */
    public function dispatchAction()
    {
        return false;
    }
}
