<?
/**
 * Samurai_Logger_Client_Mail
 * 
 * ロガークライアントの一つ。
 * メールを投げます。
 * 
 * @package    Samurai
 * @subpackage Samurai.Logger.Client
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Samurai_Logger_Client_Mail extends Samurai_Logger_Client
{
    public
        /** @var        string  From: */
        $from = "alert@localhost",
        /** @var        string  Subject: */
        $subject = "[alert] Alert of samurai.",
        /** @var        array   配送先メールアドレス */
        $mail = array();
    
    
    /**
     * 設定内容をセット。
     * @access     public
     * @see        Samurai_Logger_Client::define
     */
    public function define(array $define)
    {
        parent::define($define);
        foreach($define as $_key => $_val){
            switch($_key){
                case 'from':
                case 'subject':
                    $this->$_key = (string)$_val;
                    break;
                case 'mail':
                    $this->$_key = (array)$_val;
                    break;
            }
        }
    }
    
    
    
    /**
     * トリガーコマンド。
     * @access     public
     * @see        Samurai_Logger_Client::trigger
     */
    public function trigger($level, $message, $file, $line)
    {
        $body = $this->_makeBody($level, $message, $file, $line);
        foreach($this->mail as $mail){
            $this->_sendMail($mail, $this->from, $this->subject, $body);
        }
    }
    
    
    /**
     * メッセージを生成。
     * @access     private
     * @param      string  $level     ログレベル
     * @param      string  $message   メッセージ
     * @param      string  $file      ファイル
     * @return     int     $line      ライン
     */
    private function _makeBody($level, $message, $file, $line)
    {
        $messages = array();
        $messages[] = sprintf("%s：%s", "発生日時", date("Y/m/d H:i:s"));
        $messages[] = sprintf("%s：%s", "レベル", $level);
        $messages[] = sprintf("%s：%s", "メッセージ", $message);
        $messages[] = sprintf("%s：%s(line%s)", "ファイル", $file, $line);
        $messages[] = sprintf("%s：%s", "USER AGENT", isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : "");
        $messages[] = sprintf("%s：%s", "REQUEST URI", isset($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : "");
        return join("\r\n", $messages);
    }
    
    
    /**
     * 送信。
     * @access     private
     */
    private function _sendMail($to, $from, $subject, $body)
    {
        mb_send_mail($to, $subject, $body, "From: {$from}");
    }
}
