<?
/**
 * Filter_Validate_Validator_MailMobile
 * 
 * 携帯のメールアドレスどうか。
 * 
 * @package    Samurai
 * @subpackage Filter.Validate
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
Samurai_Loader::loadByClass("Filter_Validate_Validator_Mail");
class Filter_Validate_Validator_MailMobile extends Filter_Validate_Validator_Mail
{
    /**
     * 携帯のメールアドレスどうか。
     * @implements
     */
    public function validate($value, $params)
    {
        if(parent::validate($value, $params)){
            if(preg_match("/@softbank\.ne\.jp$/", $value)
                || preg_match("/@[dhtckrnsq]\.vodafone\.ne\.jp$/", $value)
                || preg_match("/@[dhtckrnsq]\.j-phone\.ne\.jp$/", $value)
                || preg_match("/@docomo\.ne\.jp$/", $value)
                || preg_match("/@ezweb\.ne\.jp$/", $value)
                || preg_match("/@[\w\d]+\.pdx\.ne\.jp$/", $value)){
                return true;
            }
        }
        return false;
    }
}
