<?
/**
 * Filter_Debug_Debugger_Request
 * 
 * Filter_Debugで使用されるRequestデバッガ。
 * Request関連コンポーネントの内容をデバッグウインドウに反映する。
 * 
 * @package    Filter
 * @subpackage Debug
 * @see        Samurai_Request_Http
 * @see        Samurai_Request_Session
 * @see        Samurai_Request_Cookie
 * @see        Samurai_Request_File
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Filter_Debug_Debugger_Request extends Filter_Debug_Debugger
{
    public
        $position = 'menu',
        $icon = 'Request',
        $heading = 'Request';
    public
        $Request,
        $Session,
        $Cookie,
        $File;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * setup.
     * @implements
     */
    public function setup()
    {
        $no = '(none)';
        $this->_content = array();
        //$_REQUEST
        $this->_content['$_REQUEST'] = $this->Request->getParameters();
        //$_COOKIE
        $var = $this->Cookie ? $this->Cookie->getParameters() : $no ;
        $this->_content['$_COOKIE'] = $var;
        //$_SESSION
        $var = $this->Session ? $this->Session->getParameters() : $no ;
        $this->_content['$_SESSION'] = $var;
        //$_FILES
        $var = $this->File ? $this->File->getFiles() : $no ;
        $this->_content['$_FILES'] = $var;
        //$_SERVER
        $var = (isset($_SERVER) && $_SERVER) ? $_SERVER : $no ;
        $this->_content['$_SERVER'] = $var;
    }
}
