<?
/**
 * Filter_View
 * 
 * 表示を担当するFilter。
 * 使用できるテンプレートエンジンは、今のところSmartyのみ。
 * 
 * @package    Samurai
 * @subpackage Filter
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Filter_View extends Filter_ViewSimple
{
    public
        /** @var        object  Rendererコンポーネント */
        $Renderer;
    
    
    /**
     * Template:
     * (default)
     * @access     protected
     */
    protected function _doTemplate()
    {
        if($this->_do_value){
            //Actionを登録
            $this->Renderer->setAction($this->ActionChain->getCurrentAction());
            $this->Renderer->setErrorList($this->ActionChain->getCurrentErrorList());
            //Parameter関連
            if($this->Request) $this->Renderer->setRequest($this->Request);
            if($this->Cookie)  $this->Renderer->setCookie($this->Cookie);
            if($this->Session) $this->Renderer->setSession($this->Session);
            $this->Renderer->setServer($_SERVER);
            $this->Renderer->setScriptName($_SERVER['SCRIPT_NAME']);
            //Token
            if($this->Token) $this->Renderer->setToken($this->Token);
            //表示
            $body = $this->Renderer->render($this->_do_value);
            $Body = $this->Response->setBody($body);
            if(is_object($Body) && !$this->Response->hasHeader('content-type')){
                $Body->setHeader("content-type", sprintf("text/html; charset=%s", Samurai_Config::get("encoding.output")));
            }
            $this->Response->execute();
        }
    }
}
