<?
/**
 * Etc_Mail_Transporter_Sendmail
 * 
 * Etc_Mailの送信担当者。
 * sendmailを使用して送信する。
 * 
 * @package    Samurai
 * @subpackage Etc.Mail
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Etc_Mail_Transporter_Sendmail extends Etc_Mail_Transporter
{
    public
        /** @var        string  付加オプション */
        $parameters;
    
    
    /**
     * @implements
     */
    protected function _send()
    {
        $header = $this->_adjustHeader();
        $header = join(Etc_Mail_Mime_Part::LINEEND, $header);
        mail($this->_recipients, $this->Mail->getSubject(true), $this->_body, $header, $this->parameters);
    }
    
    
    /**
     * ヘッダーの調節。
     * @access     private
     * @return     array   ヘッダー
     */
    private function _adjustHeader()
    {
        $header = array();
        foreach($this->_header as $key => $value){
            switch($key){
                case 'to':
                case 'subject':
                    break;
                default:
                    $key = join('-', array_map('ucfirst', explode('-', $key)));
                    $header[] = "{$key}: {$value}";
                    break;
            }
        }
        return $header;
    }
}
