<?
/**
 * Etc_Helper_Simple_ErrorList
 * 
 * ErrorListとSimpleをブリッジするためのヘルパー。
 * 
 * @package    Samurai
 * @subpackage Helper.Simple
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Etc_Helper_Simple_ErrorList
{
    public
        /** @var        object  ActionChainコンポーネント */
        $ActionChain;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * エラー取得メソッド。
     * @access     public
     * @return     array   エラー配列
     */
    public function getMessages($action='', $keep_key=false)
    {
        //Actionの決定
        if($action){
            $actions = $this->_resolveActions($action);
        } else {
            $actions = $this->ActionChain->getAllActionName();
        }
        //エラーの取得
        $errors = array();
        foreach($actions as $action){
            $ErrorList = $this->ActionChain->getErrorListByName($action);
            if($keep_key){
                $errors += $ErrorList->getAllMessage();
            } else {
                $errors += $ErrorList->getAllMessages();
            }
        }
        return $errors;
    }
    
    
    
    
    
    /**
     * Actionの分解。
     * @access     private
     * @param      string  $action   Action名が区切り文字で連結されているもの
     * @return     array   分解されたAction名
     */
    private function _resolveActions($action)
    {
        return preg_split('/\s*[,\|]\s*/', $action);
    }
}
