<?
/**
 * Etc_Mail
 * 
 * メール送信用クラス。
 * Mimeメールに対応し、ファイル添付、HTMLメールに対応可能。
 * 
 * @package    Samurai
 * @subpackage Etc.Mail
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
Samurai_Loader::loadByClass("Etc_Mail_Mime");
Samurai_Loader::loadByClass("Etc_Mail_Mime_Part");
Samurai_Loader::loadByClass("Etc_Mail_Address");
class Etc_Mail
{
    protected
        /** @var        array   To: */
        $_to = array(),
        /** @var        array   Cc: */
        $_cc = array(),
        /** @var        array   Bcc: */
        $_bcc = array(),
        /** @var        array   From: */
        $_from,
        /** @var        array   その他header */
        $_headers = array(),
        /** @var        string  件名 */
        $_subject = '',
        /** @var        array   本文 */
        $_bodies = array(),
        /** @var        array   添付ファイル */
        $_attaches = array();
    protected
        /** @var        string  mimeバージョン */
        $_mime_ver = '1.0',
        /** @var        string  宛先全てを連結した文字列 */
        $_envelop_to = '',
        /** @var        string  正式な送信元 */
        $_envelop_from = '',
        /** @var        string  文字コード */
        $_charset = '';
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct($charset="UTF-8")
    {
        $this->_charset = $charset;
    }
    
    
    
    
    
    /**
     * To:追加
     * @access     public
     * @param      string  $mail   メールアドレス
     * @param      string  $name   名前
     */
    public function addTo($mail, $name="")
    {
        $Address = $this->getAddress($mail, $name);
        $this->_to[] = $Address;
        return $Address;
    }
    /**
     * Cc:追加
     * @access     public
     * @param      string  $mail   メールアドレス
     * @param      string  $name   名前
     */
    public function addCc($mail, $name="")
    {
        $Address = $this->getAddress($mail, $name);
        $this->_cc[] = $Address;
        return $Address;
    }
    /**
     * Bcc:追加
     * @access     public
     * @param      string  $mail   メールアドレス
     * @param      string  $name   名前
     */
    public function addBcc($mail, $name="")
    {
        $Address = $this->getAddress($mail, $name);
        $this->_bcc[] = $Address;
        return $Address;
    }
    
    
    /**
     * 受取人を取得する。
     * 特定のフィールドに限定する事も可能。
     * @access     public
     * @param      mixed   $field   フィールドの指定
     * @return     array   受取人の一覧
     */
    public function getRecipients($field=NULL)
    {
        $recipients = array();
        if($field === NULL){
            $recipients['to'] = $this->getRecipients('to');
            $recipients['cc'] = $this->getRecipients('cc');
            $recipients['bcc'] = $this->getRecipients('bcc');
        } else {
            switch($field){
                case 'to':
                case 'cc':
                case 'bcc':
                    $recipients = $this->{"_".$field};
                    break;
                default:
                    throw new Samurai_Exception("Unkown field... -> {$field}");
                    break;
            }
        }
        return $recipients;
    }
    
    
    /**
     * 送信者設定。
     * @access     public
     * @param      string  $mail           メールアドレス
     * @param      string  $name           名前
     * @param      string  $envelop_from   envelop from
     */
    public function setFrom($mail, $name="", $envelop_from=NULL)
    {
        $Address = $this->getAddress($mail, $name);
        $this->_from = $Address;
        $this->_envelop_from = $envelop_from ? $envelop_from : $Address->mail ;
        if(!$this->hasHeader("return-path")){
            $this->setHeader("return-path", $Address->mail);
        }
        return $Address;
    }
    
    
    /**
     * 送信者の取得。
     * @access     public
     * @return     object  Etc_Mail_Address
     */
    public function getFrom()
    {
        return $this->_from;
    }
    
    
    /**
     * 件名の設定。
     * @access     public
     * @param      string  $subject   件名
     */
    public function setSubject($subject)
    {
        $subject = preg_replace("/[\r\n\t]/", " ", $subject);
        $this->_subject = $subject;
    }
    
    
    /**
     * 件名を取得する。
     * @access     public
     * @param      boolean $encode   エンコードするかどうか
     * @return     string  件名
     */
    public function getSubject($encode=false)
    {
        return $encode ? mb_encode_mimeheader($this->_subject) : $this->_subject ;
    }
    
    
    /**
     * 本文の設定。
     * @access     public
     * @param      mixed   $body   内容
     * @return     object  Etc_Mail_Mime_Part
     */
    public function setBody($body)
    {
        if(!is_object($body) || !$body instanceof Etc_Mail_Mime_Part){
            $body = (string)$body;
            $body = $this->createBody($body);
        }
        $this->_bodies[] = $body;
        return $body;
    }
    /**
     * 本文の作成。
     * @access     public
     * @param      string  $string   本文
     * @return     object  Etc_Mail_Mime_Part
     */
    public function createBody($string)
    {
        $Body = new Etc_Mail_Mime_Part($string);
        $Body->type = Etc_Mail_Mime::TYPE_TEXT;
        $Body->encoding = Etc_Mail_Mime::ENCODING_BASE64;
        $Body->charset = $this->_charset;
        return $Body;
    }
    /**
     * bodiesを取得する。
     * @access     public
     * @return     array   本文
     */
    public function getBodies()
    {
        return $this->_bodies;
    }
    
    
    /**
     * 添付ファイルの追加。
     * @access     public
     * @param      mixed   $attachment
     */
    public function addAttachment(Etc_Mail_Mime_Part $Attachment)
    {
        $this->_attaches[] = $Attachment;
    }
    /**
     * 添付ファイルの作成。
     * @access     public
     * @param      string  $string   バイナリ文字列
     */
    public function createAttachment($string, $type, $disposition=Etc_Mail_Mime::DISPOSITION_INLINE,
                                        $encoding=Etc_Mail_Mime::ENCODING_BASE64, $filename="attachment")
    {
        $Attach = new Etc_Mail_Mime_Part($string);
        $Attach->type = $type;
        $Attach->disposition = $disposition;
        $Attach->encoding = $encoding;
        $Attach->filename = $filename;
        $this->addAttachment($Attach);
        return $Attach;
    }
    /**
     * 添付ファイルを取得する。
     * @access     public
     * @return     array   添付ファイル
     */
    public function getAttaches()
    {
        return $this->_attaches;
    }
    
    
    
    
    
    /**
     * 送信トリガー。
     * @access     public
     * @param      mixed   $Transporter   Etc_Mail_Transporter
     */
    public function send($Transporter=NULL)
    {
        //Transporter補完
        if($Transporter === NULL || $Transporter instanceof Etc_Mail_Transporter){
            $Transporter = $this->getTransporter();
        }
        //日付補完
        //if(!$this->hasHeader("date")){
            $this->setHeader("date", date("r"));
        //}
        //送信
        $Transporter->send($this);
        return $this;
    }
    
    
    
    
    
    /**
     * ヘッダーをセットする。
     * @access     public
     * @param      string  $key     キー
     * @param      string  $value   値
     */
    public function setHeader($key, $value)
    {
        $this->_headers[strtolower($key)] = $value;
    }
    
    
    /**
     * ヘッダーがあるかどうか確認する。
     * @access     public
     * @param      string  $key   キー
     * @return     boolean あるかどうか
     */
    public function hasHeader($key)
    {
        return isset($this->_headers[strtolower($key)]);
    }
    
    
    /**
     * ヘッダーを取得する。
     * @access     public
     * @return     array   ヘッダー全て
     */
    public function getHeaders()
    {
        return $this->_headers;
    }
    
    
    /**
     * ボディか添付ファイルかがセットされているかをチェックする。
     * @access     public
     * @return     boolean 内容があるかどうか
     */
    public function hasContent()
    {
        return count($this->_bodies) > 0 || count($this->_attaches) > 0 ;
    }
    
    
    /**
     * メールアドレスのDTOを取得する。
     * @access     public
     * @param      string  $mail   メールアドレス
     * @param      string  $name   名前
     * @return     object  stdClass
     */
    public function getAddress($mail=NULL, $name=NULL)
    {
        if(!is_object($mail) || !$mail instanceof Etc_Mail_Address){
            $Address = new Etc_Mail_Address();
            $Address->mail = $mail;
            $Address->name = $name;
        } else {
            $Address = $mail;
        }
        return $Address;
    }
    
    
    /**
     * 送信クラスの取得。
     * @access     public
     */
    public function getTransporter($transporter="sendmail")
    {
        try{
            $class = "Etc_Mail_Transporter_".ucfirst($transporter);
            Samurai_Loader::loadByClass($class);
            $Transporter = new $class();
        } catch(Samurai_Exception $E){
            Samurai_Logger::fatal("Transporter is not found. -> %s", $transporter);
        }
        return $Transporter;
    }
    
    
    /**
     * Mailコンポーネントの初期化。
     * @access     public
     */
    public function clear()
    {
        $this->_to = array();
        $this->_cc = array();
        $this->_bcc = array();
        $this->_from = NULL;
        $this->_headers = array();
        $this->_subject = '';
        $this->_bodies = array();
        $this->_attaches =array();
        $this->_envelop_to = '';
        $this->_envelop_from = '';
    }
}
