<?
/**
 * Smarty/plugins/function.load_js.php
 * 
 * Smarty上で簡単にjavascriptをロードできるプラグイン。
 * <code>
 *     {load_js file='/path/to/file.js'}
 *     {load_js file='file:/path/to/file.js'}
 * </code>
 * 
 * @package    Smarty
 * @subpackage function
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
if(!defined('JS_URL')) define('JS_URL', '/js');
function smarty_function_load_js($params, $smarty)
{
    $file = isset($params['file']) ? $params['file'] : '' ;
    $jses = preg_split('/(\s*,\s*)/', $file);
    
    //解釈
    foreach($jses as $_key => $js){
        list($type, $file) = preg_split('#(?:(!:https?|shttp):)#', $js, 2);
        if(empty($file)){
            $file = $type;
            $type = 'url';
        }
        $jses[$_key] = array('type'=>$type, 'file'=>trim($file));
    }
    
    //読込
    $return = array();
    foreach($jses as $js){
        if($js['type']=='url'){
            $js['file'] = preg_match('#^(https?|shttp)://#', $js['file']) ? $js['file'] : sprintf('%s/%s', JS_URL, $js['file']);
            $js['file'] = preg_replace('#/\w*/\.\./#', '/', $js['file']);
            $return[] = sprintf('<SCRIPT type="text/javascript" src="%s"></SCRIPT>', $js['file']);
        } else {
            if(file_exists($js['file'])){
                $contents = file_get_contents($js['file']);
                $return[] = '<SCRIPT type="text/javascript">';
                $return[] = '<!--';
                $return[] = $contents;
                $return[] = '-->';
                $return[] = '</SCRIPT>';
            }
        }
    }
    return join("\r\n", $return);
}
