<?
/**
 * Action_Add_Template
 * 
 * Templateを生成する。
 * 
 * @package    Samurai
 * @subpackage Generator.Action.Add
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 * @license    http://opensource.org/licenses/bsd-license.php  The modified BSD License
 */
class Action_Add_Template extends Generator_Action
{
    public
        /** @var        boolean CLIテンプレートオプション */
        $cli = false;
    
    
    /**
     * 実行トリガー。
     * @access     public
     */
    public function execute()
    {
        parent::execute();
        //Usage
        if($this->_isUsage() || !$this->args) return 'usage';
        //入力チェック
        if(!$this->_checkInput()) return 'usage';
        //ループ(テンプレートを複数指定する事が可能)
        while($template_name = array_shift($this->args)){
            //Templateの追加
            $template_name = strtolower($template_name);
            if($this->cli){
                $template_file = $this->_addTemplate($template_name, $this->Generator->BROWSER_CLI);
            } else {
                $template_file = $this->_addTemplate($template_name, $this->Generator->BROWSER_WEB);
            }
        }
    }
    
    
    /**
     * 入力チェック。
     * @access     private
     * @return     boolean エラーがあったかどうか
     */
    private function _checkInput()
    {
        //テンプレート名のチェック
        foreach($this->args as &$template_name){
            if(!preg_match('/^[a-zA-Z0-9_\/\.]*?$/', $template_name)){
                $this->ErrorList->add('template_name', "{$template_name} -> Template's name is Invalid. ([a-zA-Z0-9_\\/\\.])");
            } elseif(!preg_match('/\.\w+$/', $template_name)){
                $template_name += ".tpl";
            }
        }
        return !$this->ErrorList->isExists();
    }
    
    
    /**
     * テンプレートをを追加する。
     * @access     private
     * @param      string  $template_name   テンプレート名
     * @param      int     $browser_type    ブラウザタイプ
     * @param      array   $params          Rendererに渡される値
     */
    private function _addTemplate($template_name, $browser_type, $params=array())
    {
        //Skeletonの決定
        if($browser_type == $this->Generator->BROWSER_CLI){
            $skeleton = $this->Generator->getSkeleton($this->Generator->SKELETON_CLI);
        } else {
            $skeleton = $this->Generator->getSkeleton($this->Generator->SKELETON_WEB);
        }
        //Generate
        list($result, $template_file) = $this->Generator->generate($template_name, $skeleton, $params);
        //成功
        if($result == $this->Generator->RESULT_SUCCESS){
            $this->_sendMessage("{$template_name} -> Successfully generated. [{$template_file}]");
        //既にある
        } elseif($result == $this->Generator->RESULT_ALREADY){
            $this->_sendMessage("{$template_name} -> Already exists. [{$template_file}] -> skip");
        //無視された(template_dirがない)
        } elseif($result == $this->Generator->RESULT_IGNORE){
            
        } else {
            $this->_sendMessage("{$template_name} -> Failed.");
        }
        return $template_file;
    }
}
