<?
/**
 * Samurai_Response_Http_Body
 * 
 * Samurai_Response_Http用のメッセージボディクラス。
 * Samurai_Response_Http::setBody等で返却される。
 * 
 * @package    Samurai
 * @subpackage Samurai.Response.Http
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Samurai_Response_Http_Body
{
    private
        $_body = "",
        $_headers = array();
    
    
    /**
     * コンストラクタ。
     * @access     public
     * @param      string  $body
     */
    public function __construct($body=NULL)
    {
        if(is_string($body)) $this->setBody($body);
    }
    
    
    
    
    
    /**
     * ボディをセットする。
     * @access     public
     * @param      string  $body        ボディ
     * @param      boolean $addtional   追加分かどうか
     */
    public function setBody($body, $addtional=false)
    {
        $this->_body = $addtional ? $this->_body.$body : $body;
        //debugフィルターでも出力を行うためにつじつまが合わなくなっている
        //$this->setHeader("content-length", strlen($this->_body));
    }
    
    
    /**
     * ボディを取得する。
     * @access     public
     * @return     string  ボディ
     */
    public function getBody()
    {
        return $this->_body;
    }
    
    
    /**
     * ヘッダーのセット。
     * @access     public
     * @param      string  $key     キー
     * @param      string  $value   値
     */
    public function setHeader($key, $value)
    {
        $key = strtolower($key);
        $this->_headers[$key] = $value;
    }
    
    
    /**
     * ヘッダーの取得。
     * @access     public
     * @param      string  $key   キー
     * @return     string  値
     */
    public function getHeader($key)
    {
        return isset($this->_header[$key]) ? $this->_header[$key] : NULL ;
    }
    
    
    /**
     * ヘッダーの総取得。
     * @access     public
     * @return     array   ヘッダー
     */
    public function getHeaders()
    {
        return $this->_headers;
    }
}
