<?
/**
 * Samurai_Logger_Client_PhpErrorHandler
 * 
 * ロガークライアントの一つ。
 * PHPのエラーハンダラーをロガーにブリッジします。
 * つまり、PHPのエラーが発生すると、Samurai_Logger::triggerがコールされるようになります。
 * 特殊ロガー。
 * 
 * @package    Samurai
 * @subpackage Samurai.Logger.Client
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Samurai_Logger_Client_PhpErrorHandler extends Samurai_Logger_Client
{
    public
        $LOG_LEVEL_ERROR = 1,
        $LOG_LEVEL_WARNING = 2,
        $LOG_LEVEL_PARSE = 4,
        $LOG_LEVEL_NOTICE = 8,
        $LOG_LEVEL_CORE_ERROR = 16,
        $LOG_LEVEL_CORE_WARNING = 32,
        $LOG_LEVEL_COMPILE_ERROR = 64,
        $LOG_LEVEL_COMPILE_WARNING = 128,
        $LOG_LEVEL_USER_ERROR = 256,
        $LOG_LEVEL_USER_WARNING = 512,
        $LOG_LEVEL_USER_NOTICE = 1024,
        $LOG_LEVEL_STRICT = 2048,
        $LOG_LEVEL_RECOVERABLE_ERROR = 4096;
    private
        $_fatal = array("error", "core_error", "core_warning", "compile_error", "compile_warning", "recoverable_error"),
        $_error = array("warning", "parse", "user_error", "user_warning"),
        $_warn = array("notice", "user_notice"),
        $_info = array("strict"),
        $_debug = array();
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct(array $define=array())
    {
        parent::__construct($define);
        if($this->enable){
            //set_error_handler
            set_error_handler(array($this, "trigger"));
            //通常のログトリガーで起動しないように
            $this->enable = false;
        }
    }
    
    
    /**
     * 設定内容をセット。
     * @access     public
     * @see        Samurai_Logger_Client::define
     */
    public function define(array $define)
    {
        parent::define($define);
        foreach($define as $_key => $_val){
            switch($_key){
                case 'fatal':
                case 'error':
                case 'warn':
                case 'info':
                case 'debug':
                    $_key = "_{$_key}";
                    $this->$_key = (array)$_val;
                    break;
            }
        }
    }
    
    
    
    
    
    /**
     * トリガーコマンド。
     * @access     public
     * @see        Samurai_Logger_Client::trigger
     * @param      int     $level_int   エラーレベル数値
     * @param      string  $message     メッセージ
     * @param      string  $file        ファイル
     * @param      int     $line        ライン
     */
    public function trigger($level_int, $message, $file, $line)
    {
        if($this->validLevel($level_int)){
            $level = $this->_logLevelInt2Str($level_int);
            Samurai_Logger::trigger($this->_toLoggerLevel($level), "[php error][%s] %s", array($level, $message), $file, $line);
            return false;
        } else {
            return true;
        }
    }
    
    
    /**
     * レベルの有効判断。
     * @access     public
     * @see        Samurai_Logger_Client::validLevel
     */
    public function validLevel($log_level)
    {
        if(error_reporting() === 0) return false;
        if((error_reporting() & $log_level) === 0) return false;
        return true;
    }
    
    
    /**
     * PHPのエラーレベルをSamurai_Logger上のエラーレベルに置き換える。
     * noticeもwarnに置き換えられる。
     * @access     private
     */
    private function _toLoggerLevel($log_level)
    {
        $level = "warn";
        if(in_array($log_level, $this->_fatal)){
            $level = "fatal";
        } elseif(in_array($log_level, $this->_error)){
            $level = "error";
        } elseif(in_array($log_level, $this->_warn)){
            $level = "warn";
        } elseif(in_array($log_level, $this->_info)){
            $level = "info";
        } elseif(in_array($log_level, $this->_debug)){
            $level = "debug";
        }
        return $level;
    }
}
