<?
/**
 * Samurai_Logger
 * 
 * Samurai用のロガークラス。
 * が、実際のロギング処理は担当しない。
 * あくまでもロガークライアントへのトリガークラスです。
 * <code>
 *     $define = array(
 *         "enable" => true,
 *         "client" => "SimpleFile",
 *         "log_level" => "debug"
 *     );
 *     Samurai_Logger::addClient("alias", $define);
 *     Samurai_Logger::error("message for error or logging");
 * </code>
 * 
 * @package    Samurai
 * @subpackage Component.Samurai
 * @copyright  Befool, Inc
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
Samurai_Loader::loadByClass("Samurai_Logger_Client");
class Samurai_Logger
{
    private static
        /** @var        array   client保持 */
        $_clients = array(),
        /** @var        array   メッセージ格納 */
        $_messages = array();
    
    
    /**
     * コンストラクタ。
     * @access     private
     */
    private function __construct()
    {
    }
    
    
    
    
    
    /**
     * clientrの追加。
     * aliasさえ調節すれば、いくらでも登録可能。
     * @access     public
     * @param      string  $alias    登録名
     * @param      array   $define   設定情報
     */
    public static function addClient($alias, $define)
    {
        self::$_clients[$alias] = self::createClient($define['client'], $define);
    }
    
    
    /**
     * clientの作成。
     * @param      string  $client_name   クライアント名
     * @param      array   $define        その他の宣言内容
     * @return     object  クライアントインスタンス
     */
    public static function createClient($client_name, array $define=array())
    {
        $class_name = sprintf("Samurai_Logger_Client_%s", ucfirst($client_name));
        try {
            Samurai_Loader::loadByClass($class_name);
            return new $class_name($define);
        } catch(Samurai_Exception $E){
            throw new Samurai_Exception("指定のロガークライアント({$client_name})が見つかりません。");
        }
    }
    
    
    
    
    
    /**
     * ロギングトリガー。
     * @access     public
     * @param      string  $level     ログレベル
     * @param      string  $message   メッセージ
     * @param      array   $binds     メッセージに埋め込みたいもの
     * @param      string  $file      ファイル名
     * @param      int     $line      実行ライン
     */
    public static function trigger($level, $message, $binds, $file=NULL, $line=NULL)
    {
        //メッセージの埋め込み
        $message = self::_bindMessage($message, $binds);
        //情報の補完
        if($file === NULL || $line === NULL){
            $backtrace = self::_getBacktraceInfo();
            if($file === NULL) $file = $backtrace['file'];
            if($line === NULL) $line = $backtrace['line'];
        }
        //クライアントの起動
        foreach(self::$_clients as $Client){
            if($Client->isEnable() && $Client->validLevel($level)){
                $Client->trigger($level, $message, $file, $line);
            }
        }
        self::$_messages[] = array("level"=>$level, "message"=>$message, "time"=>microtime(true));
        //ERROR以上はスクリプトの停止
        if(in_array($level, array("fatal", "error"))){
            exit;
        }
    }
    /**
     * Fatal。
     * @access     public
     * @param      string  $message   表示メッセージ
     * @param      array   $binds     メッセージに埋め込みたいもの
     */
    public static function fatal($message, $binds=array())
    {
        $backtrace = self::_getBacktraceInfo();
        self::trigger("fatal", $message, $binds, $backtrace['file'], $backtrace['line']);
    }
    /**
     * Error。
     * @access     public
     * @param      string  $message   表示メッセージ
     * @param      array   $binds     メッセージに埋め込みたいもの
     */
    public static function error($message, $binds=array())
    {
        $backtrace = self::_getBacktraceInfo();
        self::trigger("error", $message, $binds, $backtrace['file'], $backtrace['line']);
    }
    /**
     * Warn。
     * @access     public
     * @param      string  $message   表示メッセージ
     * @param      array   $binds     メッセージに埋め込みたいもの
     */
    public static function warn($message, $binds=array())
    {
        $backtrace = self::_getBacktraceInfo();
        self::trigger("warn", $message, $binds, $backtrace['file'], $backtrace['line']);
    }
    /**
     * Info。
     * @access     public
     * @param      string  $message   表示メッセージ
     * @param      array   $binds     メッセージに埋め込みたいもの
     */
    public static function info($message, $binds=array())
    {
        $backtrace = self::_getBacktraceInfo();
        self::trigger("info", $message, $binds, $backtrace['file'], $backtrace['line']);
    }
    /**
     * Debug。
     * @access     public
     * @param      string  $message   表示メッセージ
     * @param      array   $binds     メッセージに埋め込みたいもの
     */
    public static function debug($message, $binds=array())
    {
        $backtrace = self::_getBacktraceInfo();
        self::trigger("debug", $message, $binds, $backtrace['file'], $backtrace['line']);
    }
    
    
    
    
    
    /**
     * sprintfへのブリッジ。
     * @access     private
     * @param      string  $message   メッセージ本文
     * @param      array   $args      埋め込み候補
     */
    private static function _bindMessage($message, $args=array())
    {
        if(!is_array($args)) $args = array($args);
        array_unshift($args, $message);
        return call_user_func_array("sprintf", $args);
    }
    
    
    /**
     * バックトレースの情報を取得する。
     * @access     public
     * @return     array   バックトレース情報
     */
    public static function _getBacktraceInfo()
    {
        $backtrace = debug_backtrace();
        $backtrace = isset($backtrace[1]) ? $backtrace[1] : $backtrace[0] ;
        return $backtrace;
    }
    
    /**
     * プールされたメッセージを返却。
     * @access     public
     * @return     array   プールされたメッセージ
     */
    public static function getMessages()
    {
        return self::$_messages;
    }
}
