<?
/**
 * Filter_Validate_Validator_PastDate
 * 
 * 過去の日付ではないかどうか。
 * (過去の日付だと偽)
 * 
 * @package    Samurai
 * @subpackage Filter.Validate
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Filter_Validate_Validator_PastDate extends Filter_Validate_Validator
{
    public
        /** @var        object  Utilityコンポーネント */
        $Utility;
    
    
    /**
     * 過去の日付でないかどうか。
     * @implements
     */
    public function validate($value, $params)
    {
        //準備
        $today_cover = array_shift($params);
        $today_cover = $this->Utility->str2Bool($today_cover);
        if(is_array($value)){
            $year = array_shift($value);
            $month = array_shift($value);
            $day = array_shift($value);
        } else {
            list($year, $month, $day) = preg_split("/[\-\/\.]/", $value);
        }
        //比較
        $today = mktime(0, 0, 0, date("m"), date("d"), date("Y"));
        $theday = mktime(0, 0, 0, $month, $day, $year);
        if($today < $theday){
            return true;
        } elseif($today == $theday && !$today_cover){
            return true;
        }
        return false;
    }
}
