<?
/**
 * Filter_Debug_Debugger_Samurai
 * 
 * Filter_Debugで使用されるSamuraiデバッガ。
 * SamuraiFWの内容をデバッグウインドウに反映する。
 * 
 * @package    Filter
 * @subpackage Debug
 * @see        Samurai
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Filter_Debug_Debugger_Samurai extends Filter_Debug_Debugger
{
    public
        $position = 'menu',
        $icon = 'Samurai',
        $heading = 'SamuraiFW';
    public
        $ActionChain;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * setup.
     * @implements
     */
    public function setup()
    {
        //Action
        foreach($this->ActionChain->getActions() as $name => $action){
            $this->_content["Action -> {$name}"] = $action;
            $this->_content["ErrorList -> {$name}"] = $this->ActionChain->getErrorListByName($name)->getAllMessages();
        }
        //Config
        $this->_content['Config'] = Samurai_Config::getAll();
        //DIContainer
        Samurai_Loader::load(Samurai_Config::get('directory.library').'/dBug/DumpHelper.class.php');
        $DumpHelper = new dBug_DumpHelper();
        $this->_content['DIContainer'] = $DumpHelper->removeCircularReference(Samurai::getContainer()->getComponents());
    }
}
