<?
/**
 * Filter_Debug_Debugger_ExecutionTime
 * 
 * Filter_Debugで使用されるExecutionTimeデバッガ。
 * ExecutionTimeフィルターを使用している場合、そのの内容をデバッグウインドウに反映する。
 * 
 * @package    Filter
 * @subpackage Debug
 * @see        Filter_ExecutionTime
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Filter_Debug_Debugger_ExecutionTime extends Filter_Debug_Debugger
{
    public
        $position = 'menu',
        $icon = 'Execution',
        $heading = 'ExecutionTime';
    public
        $FilterChain;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    /**
     * setup.
     * @implements
     */
    public function setup()
    {
        $Filter = $this->FilterChain->getFilterByName('ExecutionTime');
        if(is_object($Filter)){
            $this->_content = array();
            $this->_content['PHP time'] = sprintf('%0.1f ms', $Filter->time_php*1000);
            $this->_content['SQL time'] = sprintf('%0.1f ms', $Filter->time_sql*1000);
            $this->_content['Total time'] = sprintf('%0.1f ms', $Filter->time*1000);
        }
    }
    
    
    /**
     * getFooterContent.
     * @override
     */
    public function getFooterContent()
    {
        $Filter = $this->FilterChain->getFilterByName('ExecutionTime');
        if(is_object($Filter)){
            return sprintf('processed in %0.1f ms', $Filter->time*1000);
        }
        return '';
    }
}
