<?
/**
 * Filter_Convert_Manager
 * 
 * コンバート処理を統括するクラス。
 * <code>
 *     $foo = $ConverterManager->convert("trim", $Request->get("foo"));
 *     $items = $ConverterManager->convert("toArray", $Request->get("items"));
 *     $dto   = $ConverterManager->convert("toObject", array("foo"=>$foo, "items"=>$items), true);
 * </code>
 * 
 * @package    Samurai
 * @subpackage Filter.Convert
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
Samurai_Loader::loadByClass("Filter_Convert_Converter");
class Filter_Convert_Manager
{
    private
        /** @var        array   コンバータキャッシュ */
        $_converters = array();
    
    
    /**
     * コンストラクタ。
     * @access    public
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * コンバート実行。
     * @access     public
     * @param      string  $converter   コンバーター名
     * @param      mixed   $value       対象値
     * @return     mixed   コンバートされた値
     */
    public function convert($converter, $value)
    {
        $Converter = $this->getConverter($converter);
        $value = $Converter->convert($value);
        return $value;
    }
    
    
    
    
    
    /**
     * コンバーター取得。
     * @access     public
     * @param      string  $name   コンバーター名
     * @return     object  コンバーター
     */
    public function getConverter($name)
    {
        //見つからない場合は作成
        if(!isset($this->_converters[$name])){
            try {
                $class = "Filter_Convert_Converter_".ucfirst($name);
                Samurai_Loader::loadByClass($class);
                $this->_converters[$name] = new $class();
            } catch(Samurai_Exception $E){
                $class = "Filter_Convert_Converter_Native";
                Samurai_Loader::loadByClass($class);
                $this->_converters[$name] = new $class($name);
            }
        }
        return $this->_converters[$name];
    }
}
