<?
/**
 * Etc_Misc_Hash
 * 
 * 暗号化のためのクラス。
 * 
 * @package    Samurai
 * @subpackage Etc.Misc
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Etc_Misc_Hash
{
    private
        /** @var        object  Blowfishインスタンス */
        $Blowfish;
    
    
    /**
     * 独自md5。
     * 単純にmd5するのではなく、複合語としてmd5化する。
     * 複合される言葉は「misc.hash.key」で指定できる。
     * @param      string  $string   暗号化対象文字列
     * @return     string  暗号化された文字列
     */
    function md5($string)
    {
        $key = Samurai_Config::get("misc.hash.key", "我思う故に我在り");
        return md5($string.$key);
    }
    
    
    /**
     * 独自blowfish暗号化。
     * 複合される言葉は「misc.hash.key」で指定できる。
     * @param      string  $string   暗号化したい文字列
     * @return     string  暗号化された文字列
     */
    function bfEncrypt($string)
    {
        if(!$this->Blowfish){
            Samurai_Loader::load("Crypt/Blowfish.php");
            $this->Blowfish = new Crypt_Blowfish(Samurai_Config::get("misc.hash.key", "我思う故に我在り"));
        }
        $encrypted = $this->Blowfish->encrypt(trim($string));
        $encrypted = bin2hex($encrypted);
        return trim($encrypted);
    }
    
    
    /**
     * 独自blowfish復号化。
     * 複合される言葉は「misc.hash.key」で指定できる。
     * @param      string  $string   復号化したい文字列
     * @return     string  復号化された文字列
     */
    function bfDecrypt($string)
    {
        if(!$this->Blowfish){
            Samurai_Loader::load("Crypt/Blowfish.php");
            $this->Blowfish = new Crypt_Blowfish(Samurai_Config::get("misc.hash.key", "我思う故に我在り"));
        }
        $decrypted = $this->Blowfish->decrypt(pack("H*",trim($string)));
        return trim($decrypted);
    }
}
