<?
/**
 * Etc_Config
 * 
 * 設定管理クラス。
 * 基本的にはSamurai_Configと同等の動きをするが、決定的に違うのは、
 * 静的参照か動的参照かの違いです。
 * Samurai_Configは単独で動作し静的に参照されますが、Etc_Configはオブジェクト化される事が前提となります。
 * また両者に繋がりはありません。
 * こちらはアプリケーション用の設定クラスだと思ってください。
 * 
 * @package    Samurai
 * @subpackage Etc.Config
 * @copyright  Befool,Inc.
 * @author     Satoshi Kiuchi <satoshi.kiuchi@befool.co.jp>
 */
class Etc_Config
{
    protected
        /** @var        array   設定情報を保持 */
        $_config = array(),
        /** @var        array   読み込まれた設定ファイルを保管 */
        $_files = array();
    public
        /** @var        object  Utilityコンポーネント */
        $Utility;
    
    
    /**
     * コンストラクタ。
     * @access     public
     */
    public function __construct()
    {
        
    }
    
    
    
    
    
    /**
     * 値の取得。
     * @access     public
     * @param      string  $key       設定キー
     * @param      mixed   $default   デフォルト値
     * @return     mixed   設定値
     */
    public function get($key, $default=NULL)
    {
        $keys = explode(".", $key);
        $value = $default;
        foreach($keys as $i => $_key){
            if(!$i && isset($this->_config[$_key])){
                $value = $this->_config[$_key];
            } elseif(is_array($value) && isset($value[$_key])){
                $value = $value[$_key];
            } else {
                $value = $default;
                break;
            }
        }
        return $value;
    }
    
    
    /**
     * 値の設定。
     * @access     public
     * @param      string  $key     設定キー
     * @param      mixed   $value   設定値
     */
    public function set($key, $value)
    {
        $keys = explode(".", $key);
        $key_str = "";
        foreach($keys as $key){
            $key_str .= (is_numeric($key) || !$key) ? "[{$key}]" : "['{$key}']" ;
        }
        $script = sprintf('$this->_config%s = $value;', $key_str);
        eval($script);
    }
    
    
    /**
     * その値を保持しているかチェック。
     * @access     public
     * @param      string  $key   設定キー
     * @return     boolean その値を保持しているかどうか
     */
    public function has($key)
    {
        $result = $this->get($key);
        return $result !== NULL;
    }
    
    
    /**
     * 設定ファイルから値を取り込む。
     * 設定ファイルが配列構造になっていても「foo.bar」のようにキーは全て文字列として評価される。
     * またそれは配列として読み込むことも可能。
     * @access     public
     * @param      string  $config_file   設定ファイル
     */
    public function import($config_file)
    {
        $config = Samurai_Yaml::load($config_file);
        $this->add($config);
        $this->_files[] = $config_file;
    }
    
    
    /**
     * 配列をまとめて追加する。
     * @access     public
     * @param      array   $config     設定配列
     */
    public function add(array $config)
    {
        if($this->Utility){
            $this->_config = $this->Utility->array_merge($this->_config, $config);
        } else {
            $this->_config = array_merge($this->_config, $config);
        }
    }
    
    
    /**
     * 設定された値をすべて取得する。
     * @access     public
     * @param      string  $prefix   prefixを指定できる
     * @return     array   検索結果
     */
    public function getAll($prefix=NULL)
    {
        if($prefix===NULL){
            return $this->_config;
        } else {
            $config = $this->get($prefix);
            return (array)$config;
        }
    }
    
    
    /**
     * 初期化。
     * @access     public
     */
    public function clear()
    {
        $this->_config = array();
    }
}
