/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementBar;
import jp.riken.brain.ni.samuraigraph.figure.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.SGIBarConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupRectangle;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Element;

public abstract class SGElementGroupBar
extends SGElementGroupRectangle
implements SGIBarConstants,
SGIElementGroupConstants {
    protected double mBaselineValue;
    protected double mWidthValue;

    public double getBaselineValue() {
        return this.mBaselineValue;
    }

    public boolean setBaselineValue(double d) {
        this.mBaselineValue = d;
        return true;
    }

    public double getWidthValue() {
        return this.mWidthValue;
    }

    public boolean setWidthValue(double d) {
        this.mWidthValue = d;
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementBar)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementBar sGDrawingElementBar = (SGDrawingElementBar)sGDrawingElement;
        this.setBaselineValue(sGDrawingElementBar.getBaselineValue());
        this.setWidthValue(sGDrawingElementBar.getWidthValue());
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                sGDrawingElementBar2D.paint(graphics2D, rectangle2D);
            }
        }
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementBar sGDrawingElementBar = (SGDrawingElementBar)this.getDrawingElementInstance();
        sGDrawingElementBar.setVisible(this.isVisible());
        sGDrawingElementBar.setEdgeLineWidth(this.getEdgeLineWidth());
        sGDrawingElementBar.setEdgeLineColor(this.getEdgeLineColor());
        sGDrawingElementBar.setColor(this.getColorList());
        sGDrawingElementBar.setBaselineValue(this.getBaselineValue());
        sGDrawingElementBar.setWidthValue(this.getWidthValue());
        return sGDrawingElementBar;
    }

    public String getTagName() {
        return "Bar";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("WidthValue", Double.toString(this.mWidthValue));
        element.setAttribute("EdgeLineWidth", Float.toString(this.mEdgeLineWidth) + "pt");
        element.setAttribute("BaselineValue", Double.toString(this.mBaselineValue));
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        element.setAttribute("EdgeLineColor", SGUtilityText.getColorString(this.mEdgeLineColor));
        return true;
    }

    public boolean readProperty(Element element) {
        Serializable serializable;
        String string = null;
        Number number = null;
        Color color = null;
        Object var8_5 = null;
        List list = null;
        string = element.getAttribute("WidthValue");
        if (string.length() != 0) {
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            if (!this.setWidthValue(number.doubleValue())) {
                return false;
            }
        }
        if ((string = element.getAttribute("Color")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() < 1) {
                return false;
            }
            if (!this.setColor(list)) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineWidth")).length() != 0) {
            serializable = new StringBuffer();
            number = SGUtilityText.getNumber(string, serializable);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            if (!this.setEdgeLineWidth(f, serializable.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("BaselineValue")).length() != 0) {
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return false;
            }
            double d = number.doubleValue();
            if (!this.setBaselineValue(d)) {
                return false;
            }
        }
        if ((string = element.getAttribute("EdgeLineColor")).length() != 0) {
            color = SGUtilityText.getColorFromString(string);
            if (color == null) {
                return false;
            }
            serializable = color;
            if (!this.setEdgeLineColor((Color)serializable)) {
                return false;
            }
        }
        return true;
    }

    protected SGDrawingElement getDrawingElementInstance() {
        return new SGDrawingElementBar2D();
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            throw new IllegalArgumentException();
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
            boolean bl = !(sGTuple2fArray[i].isInfinite() | sGTuple2fArray[i].isNaN());
            sGDrawingElementBar2D.setVisible(bl);
            if (!bl) continue;
            sGDrawingElementBar2D.setLocation(sGTuple2fArray[i]);
        }
        return true;
    }

    public boolean setHorizontal(boolean bl) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
            sGDrawingElementBar2D.setHorizontal(bl);
        }
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
            sGDrawingElementBar2D.setMagnification(this.mMagnification);
            sGDrawingElementBar2D.setColor(this.mColorList);
            sGDrawingElementBar2D.setEdgeLineWidth(this.mEdgeLineWidth);
            sGDrawingElementBar2D.setEdgeLineColor(this.mEdgeLineColor);
        }
        return true;
    }

    public SGProperties getProperties() {
        BarProperties barProperties = new BarProperties();
        if (!this.getProperties(barProperties)) {
            return null;
        }
        return barProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        BarProperties barProperties = (BarProperties)sGProperties;
        barProperties.setEdgeLineWidth(this.getEdgeLineWidth());
        barProperties.setEdgeLineColor(this.getEdgeLineColor());
        barProperties.setBaselineValue(this.getBaselineValue());
        barProperties.setWidthValue(this.getWidthValue());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        BarProperties barProperties = (BarProperties)sGProperties;
        Float f = barProperties.getBarWidth();
        if (f == null) {
            return false;
        }
        this.setRectangleWidth(f.floatValue());
        Float f2 = barProperties.getEdgeLineWidth();
        if (f2 == null) {
            return false;
        }
        this.setEdgeLineWidth(f2.floatValue());
        Color color = barProperties.getEdgeLineColor();
        if (color == null) {
            return false;
        }
        this.setEdgeLineColor(color);
        Double d = barProperties.getBaselineValue();
        if (d == null) {
            return false;
        }
        this.setBaselineValue(d);
        Double d2 = barProperties.getWidthValue();
        if (d2 == null) {
            return false;
        }
        this.setWidthValue(d2);
        return true;
    }

    public static class BarProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementBar.BarProperties mBarProperties = new SGDrawingElementBar.BarProperties();

        public boolean equals(Object object) {
            if (!(object instanceof BarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            BarProperties barProperties = (BarProperties)object;
            return this.mBarProperties.equals(barProperties.mBarProperties);
        }

        public Float getBarWidth() {
            return this.mBarProperties.getWidth();
        }

        public Float getEdgeLineWidth() {
            return this.mBarProperties.getEdgeLineWidth();
        }

        public Color getEdgeLineColor() {
            return this.mBarProperties.getEdgeLineColor();
        }

        public Double getBaselineValue() {
            return this.mBarProperties.getBaselineValue();
        }

        public Double getWidthValue() {
            return this.mBarProperties.getWidthValue();
        }

        public void setBarWidth(float f) {
            this.mBarProperties.setWidth(f);
        }

        public void setBaselineValue(double d) {
            this.mBarProperties.setBaselineValue(d);
        }

        public void setWidthValue(double d) {
            this.mBarProperties.setWidthValue(d);
        }

        public void setEdgeLineWidth(float f) {
            this.mBarProperties.setEdgeLineWidth(f);
        }

        public void setEdgeLineColor(Color color) {
            this.mBarProperties.setEdgeLineColor(color);
        }
    }
}

