
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JComboBox;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;

import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;



/**
 * A property dialog for figures with two-dimensional data.
 *
 */
public class SGXYFigureDialog extends SGPropertyDialog
	implements jp.riken.brain.ni.samuraigraph.base.SGIFigureConstants,
	jp.riken.brain.ni.samuraigraph.figure.SGIFigureTypeConstants, 
	SGILineConstants
{

	/**
	 * 
	 */
	public static final String TITLE = "Figure Properties";

    
    /** Creates new form SGFigureDialog */
    public SGXYFigureDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
		this.initialize();
    }
    
        
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mGridLabel = new javax.swing.JLabel();
        mGridDialogButton = new javax.swing.JButton();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mTabbedPane = new javax.swing.JTabbedPane();
        mFigurePanel = new javax.swing.JPanel();
        mWidthLabel = new javax.swing.JLabel();
        mHeightLabel = new javax.swing.JLabel();
        mWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mHeightSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLocationLabel = new javax.swing.JLabel();
        mSizeLabel = new javax.swing.JLabel();
        mXLabel = new javax.swing.JLabel();
        mXSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mYLabel = new javax.swing.JLabel();
        mYSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mSpaceLabel = new javax.swing.JLabel();
        mSpaceLineAndScaleLabel = new javax.swing.JLabel();
        mSpaceScaleAndTitleLabel = new javax.swing.JLabel();
        mSpaceLineAndScaleSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mSpaceScaleAndTitleSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mBackgroundColorLabel = new javax.swing.JLabel();
        mBackgroundColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mLegendVisibleCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mLegendVisibleLabel = new javax.swing.JLabel();
        mLocationSeparator = new javax.swing.JSeparator();
        mSizeSeparator = new javax.swing.JSeparator();
        mSpaceSeparator = new javax.swing.JSeparator();
        mColorSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mTransparentCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mGridPanel = new javax.swing.JPanel();
        mInnerGridPanel = new javax.swing.JPanel();
        mLineLabel = new javax.swing.JLabel();
        mLineSeparator = new javax.swing.JSeparator();
        mGridVisibleCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mLocationLabel1 = new javax.swing.JLabel();
        mLocationSeparator1 = new javax.swing.JSeparator();
        mStepXValueLabel = new javax.swing.JLabel();
        mStepXValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mBaseXValueLabel = new javax.swing.JLabel();
        mBaseXValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mStepYValueLabel = new javax.swing.JLabel();
        mStepYValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mBaseYValueLabel = new javax.swing.JLabel();
        mBaseYValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mLineTypeLabel = new javax.swing.JLabel();
        mLineTypeComboBox = new javax.swing.JComboBox();
        mLineWidthLabel = new javax.swing.JLabel();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineColorLabel = new javax.swing.JLabel();
        mLineColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mAutoCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mAxisPanel = new jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel();

        mGridLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mGridLabel.setText("Grid ");
        mGridDialogButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mGridDialogButton.setText("Show Dialog");

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mTabbedPane.setFont(new java.awt.Font("Dialog", 1, 12));
        mFigurePanel.setLayout(new java.awt.GridBagLayout());

        mFigurePanel.setFont(new java.awt.Font("Dialog", 0, 12));
        mWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mFigurePanel.add(mWidthLabel, gridBagConstraints);

        mHeightLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mHeightLabel.setText("Height");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mFigurePanel.add(mHeightLabel, gridBagConstraints);

        mWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mWidthSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mWidthSpinner, gridBagConstraints);

        mHeightSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mHeightSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mHeightSpinner, gridBagConstraints);

        mLocationLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mFigurePanel.add(mLocationLabel, gridBagConstraints);

        mSizeLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mSizeLabel, gridBagConstraints);

        mXLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mXLabel.setText("X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mFigurePanel.add(mXLabel, gridBagConstraints);

        mXSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mXSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mXSpinner, gridBagConstraints);

        mYLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mYLabel.setText("Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mFigurePanel.add(mYLabel, gridBagConstraints);

        mYSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mYSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mYSpinner, gridBagConstraints);

        mSpaceLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mSpaceLabel.setText("Space");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mSpaceLabel, gridBagConstraints);

        mSpaceLineAndScaleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSpaceLineAndScaleLabel.setText("to Scale");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mFigurePanel.add(mSpaceLineAndScaleLabel, gridBagConstraints);

        mSpaceScaleAndTitleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSpaceScaleAndTitleLabel.setText("to Title");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mFigurePanel.add(mSpaceScaleAndTitleLabel, gridBagConstraints);

        mSpaceLineAndScaleSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mSpaceLineAndScaleSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mSpaceLineAndScaleSpinner, gridBagConstraints);

        mSpaceScaleAndTitleSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mSpaceScaleAndTitleSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mSpaceScaleAndTitleSpinner, gridBagConstraints);

        mBackgroundColorLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mBackgroundColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mBackgroundColorLabel, gridBagConstraints);

        mBackgroundColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mFigurePanel.add(mBackgroundColorButton, gridBagConstraints);

        mLegendVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLegendVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mLegendVisibleCheckBox, gridBagConstraints);

        mLegendVisibleLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLegendVisibleLabel.setText("Legend ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mFigurePanel.add(mLegendVisibleLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 60, 0, 0);
        mFigurePanel.add(mLocationSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 35, 0, 0);
        mFigurePanel.add(mSizeSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 48, 0, 0);
        mFigurePanel.add(mSpaceSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 45, 0, 0);
        mFigurePanel.add(mColorSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mFigurePanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mFigurePanel.add(mRightSpaceLabel, gridBagConstraints);

        mTransparentCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mTransparentCheckBox.setText("Transparency");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mFigurePanel.add(mTransparentCheckBox, gridBagConstraints);

        mTabbedPane.addTab("Figure", mFigurePanel);

        mGridPanel.setLayout(new java.awt.GridBagLayout());

        mGridPanel.setFont(new java.awt.Font("Dialog", 0, 12));
        mInnerGridPanel.setLayout(new java.awt.GridBagLayout());

        mInnerGridPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mLineLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLineLabel.setText("Line");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 10, 0, 5);
        mInnerGridPanel.add(mLineLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(8, 40, 0, 10);
        mInnerGridPanel.add(mLineSeparator, gridBagConstraints);

        mGridVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mGridVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        mInnerGridPanel.add(mGridVisibleCheckBox, gridBagConstraints);

        mLocationLabel1.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel1.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 5, 5);
        mInnerGridPanel.add(mLocationLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 65, 5, 10);
        mInnerGridPanel.add(mLocationSeparator1, gridBagConstraints);

        mStepXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mStepXValueLabel.setText("Step X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mInnerGridPanel.add(mStepXValueLabel, gridBagConstraints);

        mStepXValueTextField.setColumns(6);
        mStepXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mInnerGridPanel.add(mStepXValueTextField, gridBagConstraints);

        mBaseXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBaseXValueLabel.setText("Base X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mInnerGridPanel.add(mBaseXValueLabel, gridBagConstraints);

        mBaseXValueTextField.setColumns(6);
        mBaseXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        mInnerGridPanel.add(mBaseXValueTextField, gridBagConstraints);

        mStepYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mStepYValueLabel.setText("Step Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mInnerGridPanel.add(mStepYValueLabel, gridBagConstraints);

        mStepYValueTextField.setColumns(6);
        mStepYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mInnerGridPanel.add(mStepYValueTextField, gridBagConstraints);

        mBaseYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBaseYValueLabel.setText("Base Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mInnerGridPanel.add(mBaseYValueLabel, gridBagConstraints);

        mBaseYValueTextField.setColumns(6);
        mBaseYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 10);
        mInnerGridPanel.add(mBaseYValueTextField, gridBagConstraints);

        mLineTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeLabel.setText("Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mInnerGridPanel.add(mLineTypeLabel, gridBagConstraints);

        mLineTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeComboBox.setPreferredSize(new java.awt.Dimension(140, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mInnerGridPanel.add(mLineTypeComboBox, gridBagConstraints);

        mLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mInnerGridPanel.add(mLineWidthLabel, gridBagConstraints);

        mLineWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        mLineWidthSpinner.setMinimumSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mInnerGridPanel.add(mLineWidthSpinner, gridBagConstraints);

        mLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mInnerGridPanel.add(mLineColorLabel, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mInnerGridPanel.add(mLineColorButton, gridBagConstraints);

        mAutoCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mAutoCheckBox.setText("Auto");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        mInnerGridPanel.add(mAutoCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mGridPanel.add(mInnerGridPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mGridPanel.add(mAxisPanel, gridBagConstraints);

        mTabbedPane.addTab("Grid", mGridPanel);

        getContentPane().add(mTabbedPane, new java.awt.GridBagConstraints());

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mAutoCheckBox;
    private jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel mAxisPanel;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mBackgroundColorButton;
    private javax.swing.JLabel mBackgroundColorLabel;
    private javax.swing.JLabel mBaseXValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mBaseXValueTextField;
    private javax.swing.JLabel mBaseYValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mBaseYValueTextField;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JSeparator mColorSeparator;
    private javax.swing.JPanel mFigurePanel;
    private javax.swing.JButton mGridDialogButton;
    private javax.swing.JLabel mGridLabel;
    private javax.swing.JPanel mGridPanel;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mGridVisibleCheckBox;
    private javax.swing.JLabel mHeightLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mHeightSpinner;
    private javax.swing.JPanel mInnerGridPanel;
    private javax.swing.JLabel mLeftSpaceLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mLegendVisibleCheckBox;
    private javax.swing.JLabel mLegendVisibleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mLineColorButton;
    private javax.swing.JLabel mLineColorLabel;
    private javax.swing.JLabel mLineLabel;
    private javax.swing.JSeparator mLineSeparator;
    private javax.swing.JComboBox mLineTypeComboBox;
    private javax.swing.JLabel mLineTypeLabel;
    private javax.swing.JLabel mLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JLabel mLocationLabel;
    private javax.swing.JLabel mLocationLabel1;
    private javax.swing.JSeparator mLocationSeparator;
    private javax.swing.JSeparator mLocationSeparator1;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mSizeLabel;
    private javax.swing.JSeparator mSizeSeparator;
    private javax.swing.JLabel mSpaceLabel;
    private javax.swing.JLabel mSpaceLineAndScaleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mSpaceLineAndScaleSpinner;
    private javax.swing.JLabel mSpaceScaleAndTitleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mSpaceScaleAndTitleSpinner;
    private javax.swing.JSeparator mSpaceSeparator;
    private javax.swing.JLabel mStepXValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mStepXValueTextField;
    private javax.swing.JLabel mStepYValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mStepYValueTextField;
    private javax.swing.JTabbedPane mTabbedPane;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mTransparentCheckBox;
    private javax.swing.JLabel mWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mWidthSpinner;
    private javax.swing.JLabel mXLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mXSpinner;
    private javax.swing.JLabel mYLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mYSpinner;
    // ϐ錾̏I//GEN-END:variables



	public static final double FIGURE_LOCATION_STEP = 1.0;
	public static final double FIGURE_SIZE_STEP = 1.0;
	public static final double FIGURE_SPACE_STEP = 0.10;


	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGXYFigureDialog.TITLE );


		//
		// Xsi[f̐ݒ
		//

		final int digits = - SGFigure.MINIMAL_LENGTH_ORDER;

		this.mXSpinner.initProperties(
			new SpinnerNumberModel(
				0.0, FIGURE_X_MIN, FIGURE_X_MAX, FIGURE_LOCATION_STEP ),
			FIGURE_LOCATION_UNIT, digits, digits );

		this.mYSpinner.initProperties(
			new SpinnerNumberModel(
				0.0, FIGURE_Y_MIN, FIGURE_Y_MAX, FIGURE_LOCATION_STEP ),
			FIGURE_LOCATION_UNIT, digits, digits );

		this.mWidthSpinner.initProperties(
			new SpinnerNumberModel(
				10.0, FIGURE_WIDTH_MIN, FIGURE_WIDTH_MAX, FIGURE_SIZE_STEP ),
			FIGURE_SIZE_UNIT, digits, digits );

		this.mHeightSpinner.initProperties(
			new SpinnerNumberModel(
				10.0, FIGURE_HEIGHT_MIN, FIGURE_HEIGHT_MAX, FIGURE_SIZE_STEP ),
			FIGURE_SIZE_UNIT, digits, digits );

		this.mSpaceLineAndScaleSpinner.initProperties(
			new SpinnerNumberModel(
				0.0, FIGURE_SPACE_TO_SCALE_MIN, FIGURE_SPACE_TO_SCALE_MAX, FIGURE_SPACE_STEP ),
			FIGURE_SPACE_UNIT, 1, 2 );

		this.mSpaceScaleAndTitleSpinner.initProperties(
			new SpinnerNumberModel(
				0.0, FIGURE_SPACE_TO_TITLE_MIN, FIGURE_SPACE_TO_TITLE_MAX, FIGURE_SPACE_STEP ),
			FIGURE_SPACE_UNIT, 1, 2 );


		// set the combo box
		{
			JComboBox cb = this.mLineTypeComboBox;
			final String array[] = {
				LINE_NAME_SOLID,
				LINE_NAME_BROKEN,
				LINE_NAME_DOT,
				LINE_NAME_DASHED,
				LINE_NAME_DOUBLE_DASHED
			};
			for(int ii=0 ; ii<array.length ; ii++)
			{
				cb.addItem( array[ii] );
			}
		}


		this.pack();

		
		// set spinner model
		this.mLineWidthSpinner.initProperties(
			getLineWidthSpinnerNumberModel(),
			LINE_WIDTH_UNIT, 1, 2 );


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mBackgroundColorButton;


		// set the name
		this.mXSpinner.setDescription("Figure-> Location-> X");
		this.mYSpinner.setDescription("Figure-> Location-> Y");
		this.mWidthSpinner.setDescription("Figure-> Size-> Width");
		this.mHeightSpinner.setDescription("Figure-> Size-> Height");
		this.mSpaceLineAndScaleSpinner.setDescription("Figure-> Space-> to Scale");
		this.mSpaceScaleAndTitleSpinner.setDescription("Figure-> Space-> to Title");
		this.mStepXValueTextField.setDescription("Grid-> Location-> StepX");
		this.mStepYValueTextField.setDescription("Grid-> Location-> StepY");
		this.mBaseXValueTextField.setDescription("Grid-> Location-> BaseX");
		this.mBaseYValueTextField.setDescription("Grid-> Location-> BaseY");
		this.mLineWidthSpinner.setDescription("Grid-> Line-> Width");


		//
		this.mTransparentCheckBox.addActionListener(this);
		this.mLegendVisibleCheckBox.addActionListener(this);


		// set action listeners
		this.mGridVisibleCheckBox.addActionListener(this);
		this.mAutoCheckBox.addActionListener(this);

		{
			this.mOKButton.addActionListener(this);
			this.mCancelButton.addActionListener(this);
			this.mPreviewButton.addActionListener(this);
		}

		return true;
	}



//	/**
//	 * 
//	 */
//	public void dispose()
//	{
//		super.dispose();
//	}


	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);

		Object source = e.getSource();
		if( source.equals( this.mTransparentCheckBox ) )
		{
			this.setFigureTransparent( this.isFigureTransparent() );
		}
		else if( source.equals( this.mLegendVisibleCheckBox ) )
		{
		}
		else if( source.equals( this.mGridDialogButton ) )
		{
			this.mColorDialog.setVisible(false);
		}
		else if( source.equals( this.mGridVisibleCheckBox ) )
		{
			this.setGridVisible( this.mGridVisibleCheckBox.getSelected() );
		}
		else if( source.equals( this.mAutoCheckBox ) )
		{
			this.setAutoFlag( this.mAutoCheckBox.getSelected() );
		}

	}


    
   	/**
	 * 
	 */
	public Number getFigureX()
	{
		return this.mXSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getFigureY()
	{
		return this.mYSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getFigureWidth()
	{
		return this.mWidthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getFigureHeight()
	{
		return this.mHeightSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getSpaceLineAndNumber()
	{
		return this.mSpaceLineAndScaleSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getSpaceNumberAndTitle()
	{
		return this.mSpaceScaleAndTitleSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Color getFigureBackgroundColor()
	{
		return this.mBackgroundColorButton.getColor();
	}

	/**
	 * 
	 * @return
	 */
	public Boolean isFigureTransparent()
	{
		return this.mTransparentCheckBox.getSelected();
	}

	/**
	 * 
	 */
	public Boolean getFigureLegendVisible()
	{
		return this.mLegendVisibleCheckBox.getSelected();
	}




	/**
	 * 
	 */
	public boolean setFigureX( final Object value )
	{
		return this.setValue( this.mXSpinner, value );
	}

	/**
	 * 
	 */
	public boolean setFigureY( final Object value )
	{
		return this.setValue( this.mYSpinner, value );
	}

	/**
	 * 
	 */
	public boolean setFigureWidth( final Object value )
	{
		return this.setValue( this.mWidthSpinner, value );
	}

	/**
	 * 
	 */
	public boolean setFigureHeight( final Object value )
	{
		return this.setValue( this.mHeightSpinner, value );
	}

	/**
	 * 
	 */
	public boolean setFigureSpaceLineAndNumber( final Object value )
	{
		return this.setValue( this.mSpaceLineAndScaleSpinner, value );
	}

	/**
	 * 
	 */
	public boolean setFigureSpaceNumberAndTitle( final Object value )
	{
		return this.setValue( this.mSpaceScaleAndTitleSpinner, value );
	}

	/**
	 * 
	 */
	public boolean setFigureBackgroundColor( final Color cl )
	{
		this.mBackgroundColorButton.setColor( cl );
		return true;
	}

	/**
	 * 
	 */
	public boolean setFigureTransparent( final Boolean b )
	{
		this.mTransparentCheckBox.setSelected(b);
		this.setBackgroundComponentsEnabled(b);
		return true;
	}


	/**
	 * 
	 * @param transparent
	 * @return
	 */
	private boolean setBackgroundComponentsEnabled( final Boolean transparent )
	{
		boolean b = true;
		if( transparent!=null )
		{
			b = !transparent.booleanValue();
		}
		
		this.mBackgroundColorButton.setEnabled(b);

		return true;
	}


	/**
	 * 
	 */
	public boolean setFigureLegendVisible( final Boolean b )
	{
		this.mLegendVisibleCheckBox.setSelected(b);
		return true;
	}



	/**
	 * 
	 * @param b
	 */
	public void setGridVisible( final Boolean b )
	{
		this.mGridVisibleCheckBox.setSelected(b);
		this.setGridComponentsEnabled(b);
	}



	private void setGridComponentsEnabled( final Boolean flag )
	{
		boolean b = false;
		if( flag!=null )
		{
			b = flag.booleanValue();
		}
		this.setGridComponentsEnabled(b);
	}

	private void setGridComponentsEnabled( final boolean b )
	{
		Component[] array =
		{
			this.mLocationLabel1,
			this.mLineLabel,
			this.mAutoCheckBox,
			this.mLineWidthLabel,
			this.mLineWidthSpinner,
			this.mLineTypeLabel,
			this.mLineTypeComboBox,
			this.mLineColorLabel,
			this.mLineColorButton
		};
		
		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii].setEnabled(b);
		}

		this.setScaleComponentsEnabled(b);
	}


	/**
	 * 
	 * @param b
	 */
	public void setAutoFlag( final Boolean b )
	{
		this.mAutoCheckBox.setSelected(b);
		this.setScaleComponentsEditable(b);
		this.setScaleComponentsEnabled(b);
	}


	private void setScaleComponentsEnabled( final Boolean auto )
	{
		boolean b;
		if( auto==null )
		{
			b = true;
		}
		else
		{
			final boolean fAuto = auto.booleanValue();

			Boolean gridVisible = this.getGridVisible();
			boolean gVisible;
			if( gridVisible==null )
			{
				gVisible = false;
			}
			else
			{
				gVisible = gridVisible.booleanValue();
			}

			b = !fAuto & gVisible;
		}

		this.setScaleComponentsEnabled(b);
	}


	private void setScaleComponentsEnabled( final boolean b )
	{
		Component[] array =
		{
			this.mBaseXValueLabel,
			this.mBaseXValueTextField,
			this.mBaseYValueLabel,
			this.mBaseYValueTextField,
			this.mStepXValueLabel,
			this.mStepXValueTextField,
			this.mStepYValueLabel,
			this.mStepYValueTextField
		};

		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii].setEnabled(b);
		}
	}



	private void setScaleComponentsEditable( final Boolean auto )
	{
		boolean flag = true;
		if( auto!=null )
		{
			flag = !auto.booleanValue();
		}
		
		this.setScaleComponentsEditable(flag);
	}


	private void setScaleComponentsEditable( final boolean b )
	{
		JTextComponent[] array =
		{
			this.mBaseXValueTextField,
			this.mBaseYValueTextField,
			this.mStepXValueTextField,
			this.mStepYValueTextField
		};

		for( int ii=0; ii<array.length; ii++ )
		{
			array[ii].setEditable(b);
		}
	}



	/**
	 * 
	 */
	public boolean setLineType( final Integer type )
	{
		if( type!=null )
		{
			final String typeName = SGDrawingElementLine.getLineTypeName( type.intValue() );
			this.mLineTypeComboBox.setSelectedItem(typeName);
		}
		else
		{
			this.mLineTypeComboBox.setSelectedItem( null );
		}

		return true;
	}


	/**
	 * 
	 * @return
	 */
	public Boolean getGridVisible()
	{
		return this.mGridVisibleCheckBox.getSelected();
	}


	/**
	 * 
	 */
	public int getLineType()
	{
		final String typeName = (String)this.mLineTypeComboBox.getSelectedItem();
		final Integer num = SGDrawingElementLine.getLineTypeFromName(typeName);
		if( num==null )
		{
			return -1;
		}
		return num.intValue();
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final Object obj )
	{
		return this.setValue( this.mLineWidthSpinner, obj );
	}


	/**
	 * 
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public boolean setLineColor( final Color cl )
	{
		this.mLineColorButton.setColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public Color getLineColor()
	{
		return this.mLineColorButton.getColor();
	}


	/**
	 * 
	 * @return
	 */
	public Boolean getAutoFlag()
	{
		return this.mAutoCheckBox.getSelected();
	}
	

    
	/**
	 * 
	 */
	public Number getBaseXValue()
	{
		String str = this.mBaseXValueTextField.getText();
		Number d = SGUtilityText.getDouble(str);
		return d;
	}


	/**
	 * 
	 */
	public Number getBaseYValue()
	{
		String str = this.mBaseYValueTextField.getText();
		Number d = SGUtilityText.getDouble(str);
		return d;
	}


	/**
	 * 
	 */
	public Number getStepXValue()
	{
		String str = this.mStepXValueTextField.getText();
		Number d = SGUtilityText.getDouble(str);
		return d;
	}


	/**
	 * 
	 */
	public Number getStepYValue()
	{
		String str = this.mStepYValueTextField.getText();
		Number d = SGUtilityText.getDouble(str);
		return d;
	}


	/**
	 * 
	 * @param value
	 */
	public void setBaseXValue( final Object value )
	{
		this.setValue( this.mBaseXValueTextField, value );
	}


	/**
	 * 
	 * @param value
	 */
	public void setStepXValue( final Object value )
	{
		this.setValue( this.mStepXValueTextField, value );
	}


	/**
	 * 
	 * @param value
	 */
	public void setBaseYValue( final Object value )
	{
		this.setValue( this.mBaseYValueTextField, value );
	}


	/**
	 * 
	 * @param value
	 */
	public void setStepYValue( final Object value )
	{
		this.setValue( this.mStepYValueTextField, value );
	}


	/**
	 * 
	 */
	public List getTextFieldComponentsList()
	{
		final List list = this.getFormattedTextFieldsListFromSpinners();
		list.addAll( this.getNumberTextFieldList() );
		return list;
	}


	/**
	 * Returns a list of text fields to set number.
	 * @return
	 */
	public List getNumberTextFieldList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mStepXValueTextField );
		list.add( this.mStepYValueTextField );
		list.add( this.mBaseXValueTextField );
		list.add( this.mBaseYValueTextField );
		return list;
	}


	/**
	 * 
	 */
	public List getColorSelectionButtonsList()
	{
		final ArrayList list = new ArrayList();
		list.add( this.mBackgroundColorButton );

		list.add( this.mLineColorButton );
		return list;
	}


	/**
	 * 
	 */
	public List getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mXSpinner );
		list.add( this.mYSpinner );
		list.add( this.mWidthSpinner );
		list.add( this.mHeightSpinner );
		list.add( this.mSpaceLineAndScaleSpinner );
		list.add( this.mSpaceScaleAndTitleSpinner );

		list.add( this.mLineWidthSpinner );
		return list;
	}



	/**
	 * 
	 */
	public boolean setDialogProperty()
	{
		final SGXYFigureDialog dg = (SGXYFigureDialog)this;
		final List list = this.mPropertyDialogObserverList;
		final SGIFigureDialogObserver figure0
			= (SGIFigureDialogObserver)list.get(0);

		final float x0 = figure0.getFigureX( cm );
		final float y0 = figure0.getFigureY( cm );
		final float width0 = figure0.getFigureWidth( cm );
		final float height0 = figure0.getFigureHeight( cm );
		final float spaceLN0 = figure0.getSpaceAxisLineAndNumber( cm );
		final float spaceNT0 = figure0.getSpaceNumberAndTitle( cm );
		final boolean legendVisible0 = figure0.isLegendVisible();
		final Color bgColor0 = figure0.getBackgroundColor();
		final boolean transparent0 = figure0.isTransparent();

		Float x = new Float( x0 );
		Float y = new Float( y0 );
		Float width = new Float( width0 );
		Float height = new Float( height0 );
		Float spaceLN = new Float( spaceLN0 );
		Float spaceNT = new Float( spaceNT0 );
		Boolean legendVisible = Boolean.valueOf( legendVisible0 );
		Color bgColor = bgColor0;
		Boolean transparent = Boolean.valueOf( transparent0 );

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIFigureDialogObserver figure1
					= (SGIFigureDialogObserver)list.get(ii);

				final float xValue1 = figure1.getFigureX( cm );
				if( x0!=xValue1 )
				{
					x = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIFigureDialogObserver figure1
					= (SGIFigureDialogObserver)list.get(ii);

				final float yValue1 = figure1.getFigureY( cm );
				if( y0!=yValue1 )
				{
					y = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIFigureDialogObserver figure1
					= (SGIFigureDialogObserver)list.get(ii);

				final float width1 = figure1.getFigureWidth( cm );
				if( width0!=width1 )
				{
					width = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIFigureDialogObserver figure1
					= (SGIFigureDialogObserver)list.get(ii);

				final float height1 = figure1.getFigureHeight( cm );
				if( height0!=height1 )
				{
					height = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIFigureDialogObserver figure1
					= (SGIFigureDialogObserver)list.get(ii);

				final float spaceLN1 = figure1.getSpaceAxisLineAndNumber( cm );
				if( spaceLN0!=spaceLN1 )
				{
					spaceLN = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIFigureDialogObserver figure1
					= (SGIFigureDialogObserver)list.get(ii);

				final float spaceNT1 = figure1.getSpaceNumberAndTitle( cm );
				if( spaceNT0!=spaceNT1 )
				{
					spaceNT = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIFigureDialogObserver figure1
					= (SGIFigureDialogObserver)list.get(ii);

				final boolean legendVisible1 = figure1.isLegendVisible();
				if( legendVisible0!=legendVisible1 )
				{
					legendVisible = null;
					break;
				}
			}
			
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIFigureDialogObserver figure1
					= (SGIFigureDialogObserver)list.get(ii);

				final Color bgColor1 = figure1.getBackgroundColor();
				if( bgColor0.equals(bgColor1) == false )
				{
					bgColor = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIFigureDialogObserver figure1
					= (SGIFigureDialogObserver)list.get(ii);

				final boolean transparent1 = figure1.isTransparent();
				if( transparent0!=transparent1 )
				{
					transparent = null;
					break;
				}
			}

		}



		//
//		if( x!=null )
//		{
//			x = new Float( x.floatValue()*CM_POINT_RATIO );
//		}
		this.setFigureX( x );

//		if( y!=null )
//		{
//			y = new Float( y.floatValue()*CM_POINT_RATIO );
//		}
		this.setFigureY( y );

//		if( width!=null )
//		{
//			width = new Float( width.floatValue()*CM_POINT_RATIO );
//		}
		this.setFigureWidth( width );

//		if( height!=null )		
//		{
//			height = new Float( height.floatValue()*CM_POINT_RATIO );
//		}
		this.setFigureHeight( height );

//		if( spaceLN!=null )
//		{
//			spaceLN = new Float( spaceLN.floatValue()*CM_POINT_RATIO );
//		}
		this.setFigureSpaceLineAndNumber( spaceLN );
		
//		if( spaceNT!=null )
//		{
//			spaceNT = new Float( spaceNT.floatValue()*CM_POINT_RATIO );
//		}
		this.setFigureSpaceNumberAndTitle( spaceNT );


		this.setFigureLegendVisible( legendVisible );

		this.setFigureBackgroundColor( bgColor );

		this.setFigureTransparent( transparent );


		if( this.setGridProperty() == false )
		{
			return false;
		}

		this.setColorButtonBorder(true);

		return true;
	}



	private boolean isGridTabEnable()
	{
		return this.mTabbedPane.isEnabledAt(1);
	}


	private void setGridTabEnabled( final boolean enable )
	{
		this.mTabbedPane.setEnabledAt(1,enable);
		if( !enable )
		{
			this.mTabbedPane.setSelectedIndex(0);
		}
	}



	private boolean setGridProperty()
	{

		List list = this.mPropertyDialogObserverList;

		if( this.mAxisPanel.setSelected( list ) == false )
		{
			return false;
		}

		SGIXYFigureDialogObserver grid0
			= (SGIXYFigureDialogObserver)list.get(0);

		final boolean gridVisible0 = grid0.isGridVisible();
		final boolean autoRange0 = grid0.isAutoCalculateRange();
		final double stepValueX0 = grid0.getGridStepValueX();
		final double stepValueY0 = grid0.getGridStepValueY();
		final double baselineValueX0 = grid0.getGridBaselineValueX();
		final double baselineValueY0 = grid0.getGridBaselineValueY();
		final float lineWidth0 = grid0.getGridLineWidth( pt );
		final int lineType0 = grid0.getGridLineType();
		final Color color0 = grid0.getGridLineColor();

		Boolean gridVisible = Boolean.valueOf( gridVisible0 );
		Boolean autoRange = Boolean.valueOf( autoRange0 );
		Double stepValueX = new Double( stepValueX0 );
		Double stepValueY = new Double( stepValueY0 );
		Double baselineValueX = new Double( baselineValueX0 );
		Double baselineValueY = new Double( baselineValueY0 );
		Float lineWidth = new Float( lineWidth0 );
		Integer lineType = new Integer( lineType0 );
		Color color = color0;


		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIXYFigureDialogObserver grid1
					= (SGIXYFigureDialogObserver)list.get(ii);
				final boolean gridVisible1 = grid1.isGridVisible();
				if( gridVisible0!=gridVisible1 )
				{
					gridVisible = null;
					break;
				}
			}
		}


//		// when grid visibility is not common,
//		// set tab disabled
//		this.setGridTabEnabled( (gridVisible!=null) );


		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIXYFigureDialogObserver grid1
					= (SGIXYFigureDialogObserver)list.get(ii);
				final boolean autoRange1 = grid1.isAutoCalculateRange();
				if( autoRange0!=autoRange1 )
				{
					autoRange = null;
					break;
				}
			}
		}

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIXYFigureDialogObserver grid1
					= (SGIXYFigureDialogObserver)list.get(ii);
				final double stepValueX1 = grid1.getGridStepValueX();
				if( stepValueX0!=stepValueX1 )
				{
					stepValueX = null;
					break;
				}
			}
		}

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIXYFigureDialogObserver grid1
					= (SGIXYFigureDialogObserver)list.get(ii);
				final double stepValueY1 = grid1.getGridStepValueY();
				if( stepValueY0!=stepValueY1 )
				{
					stepValueY = null;
					break;
				}
			}
		}

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIXYFigureDialogObserver grid1
					= (SGIXYFigureDialogObserver)list.get(ii);
				final double baselineValueX1 = grid1.getGridBaselineValueX();
				if( baselineValueX0!=baselineValueX1 )
				{
					baselineValueX = null;
					break;
				}
			}
		}

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIXYFigureDialogObserver grid1
					= (SGIXYFigureDialogObserver)list.get(ii);
				final double baselineValueY1 = grid1.getGridBaselineValueY();
				if( baselineValueY0!=baselineValueY1 )
				{
					baselineValueY = null;
					break;
				}
			}
		}

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIXYFigureDialogObserver grid1
					= (SGIXYFigureDialogObserver)list.get(ii);
				final float lineWidth1 = grid1.getGridLineWidth( pt );
				if( lineWidth0!=lineWidth1 )
				{
					lineWidth = null;
					break;
				}
			}
		}

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIXYFigureDialogObserver grid1
					= (SGIXYFigureDialogObserver)list.get(ii);
				final int lineType1 = grid1.getGridLineType();
				if( lineType0!=lineType1 )
				{
					lineType = null;
					break;
				}
			}
		}

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIXYFigureDialogObserver grid1
					= (SGIXYFigureDialogObserver)list.get(ii);
				final Color color1 = grid1.getGridLineColor();
				if( color0.equals(color1) == false )
				{
					color = null;
					break;
				}
			}
		}

		this.setAutoFlag( autoRange );
		this.setStepXValue( stepValueX );
		this.setStepYValue( stepValueY );
		this.setBaseXValue( baselineValueX );
		this.setBaseYValue( baselineValueY );
		this.setLineWidth( lineWidth );
		this.setLineType( lineType );
		this.setLineColor( color );

		this.setGridVisible( gridVisible );

		return true;
	}



	/**
	 * 
	 */
	public boolean setPropertiesToListeners( SGIPropertyDialogObserver l )
	{

		SGIXYFigureDialogObserver figure = (SGIXYFigureDialogObserver)l;

		// x
		final Number x = this.getFigureX();
		if( x!=null )
		{
//			figure.setFigureX( x.floatValue()/CM_POINT_RATIO );
			figure.setFigureX( x.floatValue(), cm );
		}


		// y
		final Number y = this.getFigureY();
		if( y!=null )
		{
//			figure.setFigureY( y.floatValue()/CM_POINT_RATIO );
			figure.setFigureY( y.floatValue(), cm );
		}

		
		// width
		final Number width = this.getFigureWidth();
		if( width!=null )
		{
//			figure.setFigureWidth( width.floatValue()/CM_POINT_RATIO );
			figure.setFigureWidth( width.floatValue(), cm );
		}


		// height
		final Number height = this.getFigureHeight();
		if( height!=null )
		{
//			figure.setFigureHeight( height.floatValue()/CM_POINT_RATIO );
			figure.setFigureHeight( height.floatValue(), cm );
		}


		// space line and number
		final Number spaceLN = this.getSpaceLineAndNumber();
		if( spaceLN!=null )
		{
//			figure.setSpaceAxisLineAndNumber( spaceLN.floatValue()/CM_POINT_RATIO );
			figure.setSpaceAxisLineAndNumber( spaceLN.floatValue(), cm );
		}


		// space number and title
		final Number spaceNT = this.getSpaceNumberAndTitle();
		if( spaceNT!=null )
		{
//			figure.setSpaceNumberAndTitle( spaceNT.floatValue()/CM_POINT_RATIO );
			figure.setSpaceNumberAndTitle( spaceNT.floatValue(), cm );
		}


		// transparent
		final Boolean transparent = this.isFigureTransparent();
		if( transparent!=null )
		{
			figure.setTransparent( transparent.booleanValue() );
		}


		// legend visible
		final Boolean legendVisible = this.getFigureLegendVisible();
		if( legendVisible!=null )
		{
			figure.setLegendVisible( legendVisible.booleanValue() );
		}


		// background color
		final Color bgColor = this.getFigureBackgroundColor();
		if( bgColor!=null )
		{
			figure.setBackgroundColor(bgColor);
		}


		// grid properties
		if( this.isGridTabEnable() )
		{
			if( this.setPropertiesToGridListeners( figure ) == false )
			{
				return false;
			}
		}

		return true;
	}



	private static final String MSG_STEP_ERROR
		= "Zero value is set to the step value";


	private boolean setPropertiesToGridListeners( SGIXYFigureDialogObserver l )
	{

		SGIXYFigureDialogObserver grid = (SGIXYFigureDialogObserver)l;

		Number stepX = this.getStepXValue();
		Number stepY = this.getStepYValue();

		// check values
		boolean valid = true;
		String msg = MSG_STEP_ERROR + ": ";
		if( l.hasValidStepXValue(stepX) == false )
		{
			valid = false;
			msg += "X";
		}
		if( l.hasValidStepYValue(stepY) == false )
		{
			if( !valid )
			{
				msg += "and ";
			}
			valid = false;
			msg += "Y";
		}
		if( !valid )
		{
			this.setInputErrorMessage( msg );
			return false;
		}


		final int xConfig = this.mAxisPanel.getXAxisConfiguration();
		final int yConfig = this.mAxisPanel.getYAxisConfiguration();
	
		// set the related axes
		if( xConfig!=-1 )
		{
			grid.setXAxisLocation( xConfig );
		}

		if( yConfig!=-1 )
		{
			grid.setYAxisLocation( yConfig );
		}


		Boolean auto = this.getAutoFlag();
		if( auto!=null )
		{
			if( grid.setAutoCalculateRange( auto.booleanValue() ) == false )
			{
				return false;
			}
		}

		Boolean visible = this.getGridVisible();
		if( visible!=null )
		{
			if( grid.setGridVisible( visible.booleanValue() ) == false )
			{
				return false;
			}
		}

		Number baseX = this.getBaseXValue();
		if( baseX!=null )
		{
			if( grid.setGridBaselineValueX( baseX.doubleValue() ) == false )
			{
				return false;
			}
		}

		Number baseY = this.getBaseYValue();
		if( baseY!=null )
		{
			if( grid.setGridBaselineValueY( baseY.doubleValue() ) == false )
			{
				return false;
			}
		}

		if( stepX!=null )
		{
			if( grid.setGridStepValueX( stepX.doubleValue() ) == false )
			{
				return false;
			}
		}

		if( stepY!=null )
		{
			if( grid.setGridStepValueY( stepY.doubleValue() ) == false )
			{
				return false;
			}
		}

		Number lineWidth = this.getLineWidth();
		if( lineWidth!=null )
		{
			if( grid.setGridLineWidth( lineWidth.floatValue(), pt ) == false )
			{
				return false;
			}
		}
		
		final int type = this.getLineType();
		if( type!=-1 )
		{
			if( grid.setGridLineType( type ) == false )
			{
				return false;
			}
		}
		
		final Color cl = this.getLineColor();
		if( cl!=null )
		{
			if( grid.setGridLineColor( cl ) == false )
			{
				return false;
			}
		}

		return true;
	}



	/**
	 * Check step values.
	 * @return
	 */
	protected boolean hasValidInputValues()
	{
		if( super.hasValidInputValues() == false )
		{
			return false;
		}
		
//		Boolean auto = this.getAutoFlag();
//		if( auto!=null )
//		{
//			if( auto.booleanValue() == false )
//			{
//				Number stepX = this.getStepXValue();
//				if( stepX!=null )
//				{
//					if( stepX.doubleValue() < 0.0 )
//					{
//						return false;
//					}
//				}
//
//				Number stepY = this.getStepYValue();
//				if( stepY!=null )
//				{
//					if( stepY.doubleValue() < 0.0 )
//					{
//						return false;
//					}
//				}
//			}
//		}
		
		return true;
	}


}


