/*
 * 쐬F 2004/12/02
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import org.w3c.dom.Element;

import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

/**
 * 
 */
public class SGTimingLine extends SGElementGroupLine
{
	
	public static final String KEY_VALUE = "Value";

	
	/**
	 * 
	 */
	protected SGAxis mAxis = null;


	/**
	 * 
	 */
	protected double mValue;
	
	
	/**
	 * 
	 */
	public SGTimingLine()
	{
		super();
	}


	
	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		TimingLineProperties p = new TimingLineProperties();
		if( this.getProperties(p) == false )
		{
			return null;
		}
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof TimingLineProperties ) == false ) return false;

		if( super.getProperties(p) == false )
		{
			return false;
		}

		TimingLineProperties lp = (TimingLineProperties)p;
		lp.setValue( this.mValue );
		lp.axis = this.mAxis;

		return true;
	}

	
	
	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof TimingLineProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;

		TimingLineProperties tp = (TimingLineProperties)p;
		Double d = tp.getValue();
		if( d==null )
		{
			return false;
		}
		this.setValue( d.doubleValue() );

		SGAxis axis = tp.axis;
		if( axis==null )
		{
			return false;
		}
		this.setAxis( axis );
		
		
		return true;
	}


	
	/**
	 * 
	 * @param el
	 * @return
	 */
	public SGProperties readProperties( final Element el )
	{
		TimingLineProperties p = new TimingLineProperties();
		if( this.readProperties( el, p ) == false ) return null;
		return p;
	}

	

	/**
	 * 
	 */
	public static class TimingLineProperties extends SGElementGroupLine.LineProperties
	{

		public static final String[] keys = { KEY_VALUE };
		
		private SGAxis axis;

		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof TimingLineProperties ) == false ) return false;
			if( super.equals(obj) == false ) return false;

			TimingLineProperties p = (TimingLineProperties)obj;
			for( int ii=0; ii<keys.length; ii++ )
			{
				if( this.getProperty(keys[ii]).equals(p.getProperty(keys[ii])) == false )
				{
					return false;
				}
			}
			if( p.axis != this.axis ) return false;

			return true;
		}

		
		public boolean setValue( final double value )
		{
			this.setProperty( KEY_VALUE, Double.toString( value ) );
			return true;
		}

		public boolean setAxis( final SGAxis axis )
		{
			this.axis = axis;
			return true;
		}
		
		public Double getValue()
		{
			final String value = this.getProperty( KEY_VALUE );
			return SGUtilityText.getDouble(value);
		}

		public SGAxis getAxis()
		{
			return this.axis;
		}
	}


	/**
	 * @return mAxis
	 */
	public SGAxis getAxis()
	{
		return mAxis;
	}

	
	/**
	 * @param axis mAxis ݒ肵܂B
	 */
	public void setAxis( final SGAxis axis )
	{
		mAxis = axis;
	}

	
	/**
	 * @return mValue
	 */
	public double getValue()
	{
		return mValue;
	}

	
	/**
	 * @param value mValue ݒ肵܂B
	 */
	public void setValue( final double value )
	{
		mValue = value;
	}

}

