
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import org.w3c.dom.Document;


/**
 * An interface for objects on a figure.
 */

public interface SGIGraphElement extends SGIFigureElement
{

	/**
	 * 
	 */
	public boolean setAxisElement( SGIAxisElement aElement );


	/**
	 * Set the name of a data object.
	 * @param data - the data object to get the name
	 * @return the name of data object
	 */
	public String getDataName( SGData data );


	/**
	 * Set the name of a data object.
	 * @param data - the data object to set the name
	 * @return true:succeeded, false:failed
	 */
	public boolean setDataName( String name, SGData data );



	/**
	 * 
	 */
	public ArrayList getDrawingElementList( SGData data );


	/**
	 * 
	 */
	public boolean isDataVisible( SGData data );



	/**
	 * 
	 * @param document
	 * @return
	 */
	public boolean createElementOfData( Document document, ArrayList elList );

	
	
	/**
	 * 
	 * @return
	 */
	public ArrayList getVisibleDataList();


	/**
	 * 
	 */
	public int getSelectedDataNumber();


	/**
	 * 
	 */
	public boolean removeSelectedData();


	/**
	 * 
	 */
	public boolean changeXAxis( SGData data );


	/**
	 * 
	 */
	public boolean changeYAxis( SGData data );


	/**
	 * 
	 */
	public boolean changeZAxis( SGData data );


	/**
	 * 
	 */
	public ArrayList getVisibleFlagList( SGData data );


	/**
	 * 
	 * @param data
	 * @return
	 */
	public boolean getVisibleInLegendFlag( SGData data );



	/**
	 * 
	 * @return
	 */
	public ArrayList getPropertySettingListerListOfDataElements();


	/**
	 * 
	 * @return
	 */
	public SGPropertyDialog getPropertyDialogForDataElements();



	/**
	 * Returns a list of copies of the focused data objects.
	 * @return a list to which the cut data objects are added
	 */
	public ArrayList getFocusedDataList();


	/**
	 * Returns a list of the cut data objects.
	 * @return a list to which the cut data objects are added
	 */
	public ArrayList cutFocusedData();



	public static final String TAG_NAME_GRAPH = "Graph";

	public static final String TAG_NAME_DATA = "Data";

	public static final String PF_SAMPLING_RATE = "SamplingRate";




}

