
package jp.riken.brain.ni.samuraigraph.base;


/**
 * NX
 */

public class SGAxis
{

	/**
	 * jAXP[
	 */
	public static final int LINEAR_TYPE = 0;


	/**
	 * OXP[
	 */
	public static final int LOG_TYPE = 1;


	/**
	 * XP[̎
	 */
	private int mScaleType = LINEAR_TYPE;


	/**
	 * XP[ŏl
	 */
	private double mMinValue;


	/**
	 * XP[ől
	 */
	private double mMaxValue;




	/**
	 * RXgN^
	 */
	public SGAxis()
	{
	}



	/**
	 * W̐ݒ
	 * @param minValue ŏl
	 * @param maxValue ől
	 * @return true:Afalse:s
	 */
	public boolean setRange(
		final double minValue, final double maxValue )
	{
		if( minValue > maxValue )
		{
			new IllegalArgumentException("minValue > maxValue");
		}

		mMinValue = minValue;
		mMaxValue = maxValue;
		return true;
	}


	/**
	 * 
	 */
	public boolean setRange( final SGTuple2d range )
	{
		return this.setRange( range.x, range.y );
	}


	/**
	 * XP[^Cv̐ݒ
	 * @param scaleType XP[̃^Cv
	 * @return true:Afalse:s
	 */
	public boolean setScaleType( final int scaleType )
	{
		if( scaleType!= LINEAR_TYPE && scaleType!=LOG_TYPE )
		{
			new IllegalArgumentException("scale type is incorrect");
		}

		if( scaleType == LOG_TYPE )
		{
			if( mMinValue < 0.0 )
			{
				System.out.println("mMinValue < 0.0 : cannot set log-type scale");
				return false;
			}
		}

		mScaleType = scaleType;
		return true;
	}


	/**
	 * 
	 */
	public double getMinValue()
	{
		return this.mMinValue;
	}
	
	
	/**
	 * 
	 */
	public double getMaxValue()
	{
		return this.mMaxValue;
	}


	/**
	 * W̎擾
	 */
	public SGTuple2d getRange()
	{
		final SGTuple2d range = new SGTuple2d( mMinValue, mMaxValue );
		return range;
	}


	/**
	 * XP[^Cv̎擾
	 */
	public int getScaleType()
	{
		return mScaleType;
	}


	/**
	 * 
	 */
	public boolean insideRange( final double value )
	{
		if( value < this.mMinValue || value > this.mMaxValue )
		{
			return false;
		}
	
		return true;		
	}



}

