
package jp.riken.brain.ni.samuraigraph.application;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.DOMImplementation;

/**
 * 
 * This class provides static methods for the application.
 */
public class SGApplicationUtility
{

	/**
	 * Delete all files recursively.
	 * @param f The abstract pathname to be deleted.
	 */
	public static void deleteRecursively( final File f )
	{
		if( f.isDirectory() )
		{
			String dir = f.getAbsolutePath();
			String[] fList = f.list();
			for( int ii=0; ii<fList.length; ii++ )
			{
				File f_ = new File( f+"\\"+fList[ii] );
				deleteRecursively( f_ );
			}
		}

		f.delete();
	}
	

	/**
	 * Delete all files recursively when the virtual machine terminates.
	 * @param f The abstract pathname to be deleted.
	 */
	public static void deleteOnExitRecursively( final File f )
	{
		if( f.isDirectory() )
		{
			String dir = f.getAbsolutePath();
			String[] fList = f.list();
			for( int ii=0; ii<fList.length; ii++ )
			{
				File f_ = new File( f+"\\"+fList[ii] );
				deleteOnExitRecursively( f_ );
			}
		}

		f.deleteOnExit();
	}



	/**
	 * Copy file from f1 to f2.
	 * @param f1
	 * @param f2
	 * @return true:success, false:failure
	 */
	public static boolean copyBinaryFile(
		final File f1, final File f2 )
		throws IOException
	{
		if( f1==null | f2==null )
		{
			return false;
		}

		FileInputStream in = null;
		FileOutputStream out = null;
		try
		{
			in = new FileInputStream(f1);
			out = new FileOutputStream(f2);
		}
		catch( FileNotFoundException ex )
		{
			if( in!=null )
			{
				in.close();
			}
			if( out!=null )
			{
				out.close();
			}
			return false;
		}

		BufferedInputStream bis = new BufferedInputStream(in);
		BufferedOutputStream bos = new BufferedOutputStream(out);

		final int bufferLength = 1024;
		byte[] buffer = new byte[bufferLength];
		int len;
		while( (len=bis.read(buffer,0,bufferLength))!=-1 )
		{
			bos.write( buffer, 0, len );
		}


		// close I/O streams
		bis.close();
		bos.close();		
		
		return true;	
	}



	/**
	 * Copy file from f1 to f2.
	 * @param f1
	 * @param f2
	 * @return true:success, false:failure
	 */
	public static boolean copyBinaryFile( final String f1, final String f2 )
		throws IOException
	{
		if( f1==null || f2==null )
		{
			return false;
		}
		return copyBinaryFile( new File(f1), new File(f2) );
	}



	/**
	 * Returns a DOMImplementation instance.
	 * @return
	 */
	public static DOMImplementation getDOMImplementation()
	{
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = null;
		try
		{
			builder = factory.newDocumentBuilder();
		}
		catch( ParserConfigurationException ex )
		{
			return null;
		}
		DOMImplementation domImpl = builder.getDOMImplementation();

		return domImpl;
	}

}

