
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;


/**
 *
 */
public abstract class SGDrawingElementSymbol extends SGDrawingElement
{

	/**
	 * 
	 */
	protected SGTuple2f mLocation = new SGTuple2f();
	
	
	/**
	 * 
	 */
	protected float mSize;


	/**
	 * 
	 */
	protected int mType;


	/**
	 * 
	 */
	protected float mAngle;


	/**
	 * 
	 */
	protected Color mLineColor;


	/**
	 * 
	 */
	protected float mLineWidth;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_VOID = -1;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_CIRCLE = 0;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_SQUARE = 1;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_TRIANGLE = 2;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_INVERTEDTRIANGLE = 3;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_CROSS = 4;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_PLUS = 5;


	/**
	 * 
	 */
	public static final int SYMBOL_TYPE_TRANSVERSELINE = 6;


	/**
	 * 
	 */
	public static final String SYMBOL_VOID = "No Symbol";

	/**
	 * 
	 */
	public static final String SYMBOL_CIRCLE = "Circle";

	/**
	 * 
	 */
	public static final String SYMBOL_SQUARE = "Square";

	/**
	 * 
	 */
	public static final String SYMBOL_TRIANGLE = "Triangle";

	/**
	 * 
	 */
	public static final String SYMBOL_INVERTED_TRIANGLE = "I-Triangle";

	/**
	 * 
	 */
	public static final String SYMBOL_CROSS = "Cross";

	/**
	 * 
	 */
	public static final String SYMBOL_PLUS = "Plus";

	/**
	 * 
	 */
	public static final String SYMBOL_TRANSVERSELINE = "Transverse Line";



	/**
	 * 
	 */
	public SGDrawingElementSymbol()
	{
		super();
	}



	/**
	 * 
	 */
	public boolean setLocation( final float x, final float y )
	{
		this.mLocation.setValues(x,y);
		return true;
	}


	/**
	 * 
	 */
	public boolean setLocation( final SGTuple2f point )
	{
		this.mLocation = point;
		return true;
	}


	/**
	 * 
	 */
	public boolean setSize( final float size )
	{
		this.mSize = size;
		return true;
	}


	/**
	 * 
	 */
	public boolean setType( final int type )
	{
		this.mType = type;
		return true;
	}


	/**
	 * 
	 */
	public boolean setAngle( final float angle )
	{
		this.mAngle = angle;
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineColor( final Color color )
	{
		this.mLineColor = color;
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float lineWidth )
	{
		this.mLineWidth = lineWidth;
		return true;
	}


	/**
	 * 
	 */
	public SGTuple2f getLocation()
	{
		return new SGTuple2f( this.mLocation );
	}

	/**
	 * 
	 */
	public float getX()
	{
		return this.mLocation.x;
	}


	/**
	 * 
	 */
	public float getY()
	{
		return this.mLocation.y;
	}



	/**
	 * 
	 */
	public float getSize()
	{
		return this.mSize;
	}


	/**
	 * 
	 */
	public int getType()
	{
		return this.mType;
	}


	/**
	 * 
	 */
	public float getAngle()
	{
		return this.mAngle;
	}


	/**
	 * 
	 */
	public Color getLineColor()
	{
		return this.mLineColor;
	}


	/**
	 * 
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}



	/**
	 * 
	 */
	public static Integer getSymbolTypeFromName( final String name )
	{

		if( name==null )
		{
			return null;
		}
		
		int type;
		if( name.equals( SGDrawingElementSymbol.SYMBOL_VOID ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_VOID;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_CIRCLE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_SQUARE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_SQUARE;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_TRIANGLE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_TRIANGLE;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_INVERTED_TRIANGLE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_INVERTEDTRIANGLE;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_CROSS ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_CROSS;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_PLUS ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_PLUS;
		}
		else if( name.equals( SGDrawingElementSymbol.SYMBOL_TRANSVERSELINE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE;
		}
		else
		{
			return null;
		}

		return new Integer(type);
	}



	/**
	 * 
	 */
	public static String getSymbolTypeName( final int type )
	{
		
		String name = null;
		switch( type )
		{
			case SGDrawingElementSymbol.SYMBOL_TYPE_VOID :
			{
				name = SGDrawingElementSymbol.SYMBOL_VOID;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE :
			{
				name = SGDrawingElementSymbol.SYMBOL_CIRCLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_SQUARE :
			{
				name = SGDrawingElementSymbol.SYMBOL_SQUARE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_TRIANGLE :
			{
				name = SGDrawingElementSymbol.SYMBOL_TRIANGLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_INVERTEDTRIANGLE :
			{
				name = SGDrawingElementSymbol.SYMBOL_INVERTED_TRIANGLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_CROSS :
			{
				name = SGDrawingElementSymbol.SYMBOL_CROSS;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_PLUS :
			{
				name = SGDrawingElementSymbol.SYMBOL_PLUS;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE :
			{
				name = SGDrawingElementSymbol.SYMBOL_TRANSVERSELINE;
				break;
			}

			default :
			{
				
			}
		}
		
		return name;
	}




	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		SymbolProperties p = new SymbolProperties();
		this.getProperties(p);
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof SymbolProperties ) == false ) return false;

		super.getProperties(p);

		SymbolProperties sp = (SymbolProperties)p;
		sp.setSize( this.getSize() );
		sp.setSymbolType( this.getType() );
		sp.setLineWidth( this.getLineWidth() );
		sp.setLineColor( this.getLineColor() );
		sp.angle = this.getAngle();

		return true;
	}




	public static final String KEY_SYMBOL_SIZE = "Size";
	public static final String KEY_SYMBOL_TYPE = "Type";
	public static final String KEY_LINE_WIDTH = "Edge Line Width";
	public static final String KEY_LINE_COLOR = "Edge Line Color";
	public static final String PF_SYMBOL_COLOR_LIST = "Inner Color List";


	/**
	 * 
	 */
	public static class SymbolProperties extends DrawingElementProperties
	{
		double angle;

		public static final String[] keys = {
			KEY_SYMBOL_TYPE, KEY_SYMBOL_SIZE,
			KEY_LINE_WIDTH, KEY_LINE_COLOR
		};


		/**
		 * 
		 *
		 */
		public SymbolProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof SymbolProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

			SymbolProperties p = (SymbolProperties)obj;
			for( int ii=0; ii<keys.length; ii++ )
			{
				if( this.getProperty(keys[ii]).equals(p.getProperty(keys[ii])) == false )
				{
					return false;
				}
			}

			if( p.angle != this.angle ) return false;

			return true;
		}


		public Float getSize()
		{
			final String value = this.getProperty(KEY_SYMBOL_SIZE);
			return SGUtilityText.getFloat(value);
		}

		public Integer getSymbolType()
		{
			final String value = this.getProperty(KEY_SYMBOL_TYPE);
			return SGUtilityText.getInteger(value);
		}

		public Float getLineWidth()
		{
			final String value = this.getProperty(KEY_LINE_WIDTH);
			return SGUtilityText.getFloat(value);
		}

		public Color getLineColor()
		{
			final String value = this.getProperty(KEY_LINE_COLOR);
			return SGUtilityText.getColorFromString(value);
		}


		public boolean setSize( final float size )
		{
			if( size<0.0f )
			{
				return false;
			}
			this.setProperty( KEY_SYMBOL_SIZE, new Float(size).toString() );
			return true;
		}


		public boolean setSymbolType( final int type )
		{
			this.setProperty( KEY_SYMBOL_TYPE, new Integer(type).toString() );
			return true;
		}


		public boolean setLineWidth( final float width )
		{
			if( width<0.0f )
			{
				return false;
			}
			this.setProperty( KEY_LINE_WIDTH, new Float(width).toString() );
			return true;
		}

		public boolean setLineColor( final Color cl )
		{
			if( cl==null )
			{
				return false;
			}
			String str = SGUtilityText.getColorString(cl);
			if( str==null )
			{
				return false;
			}
			this.setProperty( KEY_LINE_COLOR, str );
			return true;
		}


	}



}

