
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.base.*;


/**
 * (x,y)-type data.
 */

public class SGSXYData extends SGData implements SGITwoDimensionalData
{

	/**
	 * Array of (x,y)-datas.
	 */
	private SGTuple2d[] mValueArray = null;


	/**
	 * Array of errors.
	 */
	private SGTuple2d[] mErrorArray = null;


	/**
	 * Array of strings.
	 */
	private String[] mStringArray = null;



	/**
	 * 
	 */
	public SGSXYData()
	{
		super();
	}


	/**
	 * Constructor.
	 */
	public SGSXYData( SGTuple2d[] valueArray, SGTuple2d[] errorArray, String[] stringArray )
	{
		super();

		this.setValueArray( valueArray );
		this.setErrorArray( errorArray );
		this.setStringArray( stringArray );
	}


	/**
	 * Constructor.
	 */
	public SGSXYData(
		double[] xValueArray,
		double[] yValueArray,
		double[] xErrorArray,
		double[] yErrorArray,
		String[] stringArray )
	{
		super();

// `FbNKvI
int num = xValueArray.length;

		if( xValueArray!=null && yValueArray!=null )
		{
			mValueArray = new SGTuple2d[num];
			for( int ii=0; ii<num; ii++ )
			{
				mValueArray[ii] = new SGTuple2d( xValueArray[ii], yValueArray[ii] );
			}
		}

		if( xErrorArray!=null && yErrorArray!=null )
		{
			mErrorArray = new SGTuple2d[num];
			for( int ii=0; ii<num; ii++ )
			{
				mErrorArray[ii] = new SGTuple2d( xErrorArray[ii], yErrorArray[ii] );
			}
		}

		if( stringArray!=null )
		{
			mStringArray = new String[num];
			for( int ii=0; ii<num; ii++ )
			{
				mStringArray[ii] = new String( stringArray[ii] );
			}
		}

/*
System.out.println(mValueArray);
System.out.println(mErrorArray);
System.out.println(mStringArray);
System.out.println();
*/

	}



	/**
	 * 
	 */
	public SGSXYData( final double[] xValueArray, final double[] yValueArray )
	{
		if( xValueArray==null || yValueArray==null )
		{
			throw new Error();
		}

		if( xValueArray.length!=yValueArray.length )
		{
			throw new Error();
		}

		final int num = xValueArray.length;
		mValueArray = new SGTuple2d[num];
		for( int ii=0; ii<num; ii++ )
		{
			mValueArray[ii] = new SGTuple2d( xValueArray[ii], yValueArray[ii] );
		}
	}



	/**
	 * 
	 * @return
	 */
	public SGSXYData( final SGData data )
	{
		super();
		this.setData( data );
	}


	/**
	 * 
	 */
	public boolean setData( final SGData data )
	{

		if( !(data instanceof SGSXYData) )
		{
			return false;
		}

		SGSXYData data_ = (SGSXYData)data;
		this.setValueArray( data_.getValueArray() );
		this.setErrorArray( data_.getErrorArray() );
		this.setStringArray( data_.getStringArray() );

		return true;
	}


	/**
	 * 
	 * @return
	 */
	public int getPointsNumber()
	{
		return this.mValueArray.length;
	}


	/**
	 * 
	 * @return
	 */
	public double getMinValueX()
	{
		double min = Double.MAX_VALUE;

		for( int ii=0; ii<mValueArray.length; ii++ )
		{
			double x = mValueArray[ii].x;
			if( x < min )
			{
				min = x;
			}
		}

		return min;
	}


	/**
	 * 
	 * @return
	 */
	public double getMaxValueX()
	{
		double max = - Double.MAX_VALUE;

		for( int ii=0; ii<mValueArray.length; ii++ )
		{
			double x = mValueArray[ii].x;
			if( x > max )
			{
				max = x;
			}
		}

		return max;
	}


	/**
	 * 
	 * @return
	 */
	public double getMinValueY()
	{
		double min = Double.MAX_VALUE;

		for( int ii=0; ii<mValueArray.length; ii++ )
		{
			double y = mValueArray[ii].y;
			if( y < min )
			{
				min = y;
			}
		}

		return min;
	}


	/**
	 * 
	 * @return
	 */
	public double getMaxValueY()
	{
		double max = - Double.MAX_VALUE;

		for( int ii=0; ii<mValueArray.length; ii++ )
		{
			double y = mValueArray[ii].y;
			if( y > max )
			{
				max = y;
			}
		}

		return max;
	}


	/**
	 * 
	 * @return
	 */
	public SGTuple2d[] getValueArray()
	{
		return mValueArray;
	}


	/**
	 * 
	 * @return
	 */
	public SGTuple2d[] getErrorArray()
	{
		return mErrorArray;
	}


	/**
	 * 
	 * @return
	 */
	public String[] getStringArray()
	{
		return mStringArray;
	}


	/**
	 * 
	 */
	private boolean setValueArray( final SGTuple2d[] array )
	{
		this.mValueArray = array;
		return true;
	}


	/**
	 * 
	 */
	private boolean setErrorArray( final SGTuple2d[] array )
	{
		this.mErrorArray = array;
		return true;
	}


	/**
	 * 
	 */
	private boolean setStringArray( final String[] array )
	{
		this.mStringArray = array;
		return true;
	}



}
